/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public interface EntityId {
    public long id();

    public void enhance(Document var1);

    public static class LongCostume
    extends IdData {
        public LongCostume() {
            super(-1L);
        }

        public LongCostume setId(long id) {
            this.id = id;
            return this;
        }
    }

    public static class RelationshipData
    extends AbstractData {
        private final long startNode;
        private final long endNode;

        public RelationshipData(long id, long startNode, long endNode) {
            super(id);
            this.startNode = startNode;
            this.endNode = endNode;
        }

        @Override
        public void enhance(Document document) {
            document.add((IndexableField)new StringField("_start_node_id_", "" + this.startNode, Field.Store.YES));
            document.add((IndexableField)new StringField("_end_node_id_", "" + this.endNode, Field.Store.YES));
        }
    }

    public static class IdData
    extends AbstractData {
        public IdData(long id) {
            super(id);
        }

        @Override
        public void enhance(Document document) {
        }
    }

    public static abstract class AbstractData
    implements EntityId {
        protected long id;

        AbstractData(long id) {
            this.id = id;
        }

        @Override
        public long id() {
            return this.id;
        }

        public boolean equals(Object obj) {
            return obj instanceof EntityId && ((EntityId)obj).id() == this.id;
        }

        public int hashCode() {
            return (int)(this.id >>> 32 ^ this.id);
        }
    }
}

