/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Level;

public class FormattedLogProvider
extends AbstractLogProvider<FormattedLog> {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(\\w)\\w+\\.");
    private final Supplier<PrintWriter> writerSupplier;
    private final ZoneId zoneId;
    private final boolean renderContext;
    private final Map<String, Level> levels;
    private final Level defaultLevel;
    private final boolean autoFlush;

    public static Builder withoutRenderingContext() {
        return new Builder().withoutRenderingContext();
    }

    public static Builder withUTCTimeZone() {
        return new Builder().withUTCZoneId();
    }

    public static Builder withZoneId(ZoneId zoneId) {
        return new Builder().withZoneId(zoneId);
    }

    @Deprecated
    public static Builder withTimeZone(TimeZone timeZone) {
        return new Builder().withZoneId(timeZone.toZoneId());
    }

    public static Builder withDefaultLogLevel(Level level) {
        return new Builder().withDefaultLogLevel(level);
    }

    public static Builder withoutAutoFlush() {
        return new Builder().withoutAutoFlush();
    }

    public static FormattedLogProvider toOutputStream(OutputStream out) {
        return new Builder().toOutputStream(out);
    }

    public static FormattedLogProvider toOutputStream(Supplier<OutputStream> outSupplier) {
        return new Builder().toOutputStream(outSupplier);
    }

    public static FormattedLogProvider toWriter(Writer writer) {
        return new Builder().toWriter(writer);
    }

    public static FormattedLogProvider toPrintWriter(PrintWriter writer) {
        return new Builder().toPrintWriter(writer);
    }

    public static FormattedLogProvider toPrintWriter(Supplier<PrintWriter> writerSupplier) {
        return new Builder().toPrintWriter(writerSupplier);
    }

    FormattedLogProvider(Supplier<PrintWriter> writerSupplier, ZoneId zoneId, boolean renderContext, Map<String, Level> levels, Level defaultLevel, boolean autoFlush) {
        this.writerSupplier = writerSupplier;
        this.zoneId = zoneId;
        this.renderContext = renderContext;
        this.levels = new HashMap<String, Level>(levels);
        this.defaultLevel = defaultLevel;
        this.autoFlush = autoFlush;
    }

    @Override
    protected FormattedLog buildLog(Class loggingClass) {
        String className = loggingClass.getName();
        String shortenedClassName = PACKAGE_PATTERN.matcher(className).replaceAll("$1.");
        return this.buildLog(shortenedClassName, this.levelForContext(className));
    }

    @Override
    protected FormattedLog buildLog(String name) {
        return this.buildLog(name, this.levelForContext(name));
    }

    private FormattedLog buildLog(String context, Level level) {
        return new FormattedLog(this.writerSupplier, this.zoneId, this, this.renderContext ? context : null, level, this.autoFlush);
    }

    private Level levelForContext(String context) {
        for (Map.Entry<String, Level> entry : this.levels.entrySet()) {
            if (!context.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultLevel;
    }

    public static class Builder {
        private boolean renderContext = true;
        private ZoneId zoneId = ZoneOffset.UTC;
        private Map<String, Level> levels = new HashMap<String, Level>();
        private Level defaultLevel = Level.INFO;
        private boolean autoFlush = true;

        private Builder() {
        }

        public Builder withoutRenderingContext() {
            this.renderContext = false;
            return this;
        }

        public Builder withUTCZoneId() {
            return this.withZoneId(ZoneOffset.UTC);
        }

        public Builder withZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        @Deprecated
        public Builder withTimeZone(TimeZone timezone) {
            return this.withZoneId(timezone.toZoneId());
        }

        public Builder withDefaultLogLevel(Level level) {
            this.defaultLevel = level;
            return this;
        }

        public Builder withLogLevel(String context, Level level) {
            this.levels.put(context, level);
            return this;
        }

        public Builder withLogLevels(Map<String, Level> levels) {
            this.levels.putAll(levels);
            return this;
        }

        public Builder withoutAutoFlush() {
            this.autoFlush = false;
            return this;
        }

        public FormattedLogProvider toOutputStream(OutputStream out) {
            return this.toPrintWriter(Suppliers.singleton((Object)FormattedLog.OUTPUT_STREAM_CONVERTER.apply(out)));
        }

        public FormattedLogProvider toOutputStream(Supplier<OutputStream> outSupplier) {
            return this.toPrintWriter(Suppliers.adapted(outSupplier, FormattedLog.OUTPUT_STREAM_CONVERTER));
        }

        public FormattedLogProvider toWriter(Writer writer) {
            return this.toPrintWriter(new PrintWriter(writer));
        }

        public FormattedLogProvider toPrintWriter(PrintWriter writer) {
            return this.toPrintWriter(Suppliers.singleton((Object)writer));
        }

        public FormattedLogProvider toPrintWriter(Supplier<PrintWriter> writerSupplier) {
            return new FormattedLogProvider(writerSupplier, this.zoneId, this.renderContext, this.levels, this.defaultLevel, this.autoFlush);
        }
    }
}

