/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping;

import java.util.function.LongFunction;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.TrackerFactories;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;

public class IdMappers {
    private IdMappers() {
    }

    public static IdMapper actual() {
        return new ActualIdMapper();
    }

    public static IdMapper strings(NumberArrayFactory cacheFactory, Groups groups) {
        return new EncodingIdMapper(cacheFactory, new StringEncoder(), Radix.STRING, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(), groups, numberOfCollisions -> new StringCollisionValues(cacheFactory, numberOfCollisions));
    }

    public static IdMapper longs(NumberArrayFactory cacheFactory, Groups groups) {
        return new EncodingIdMapper(cacheFactory, new LongEncoder(), Radix.LONG, EncodingIdMapper.NO_MONITOR, TrackerFactories.dynamic(), groups, numberOfCollisions -> new LongCollisionValues(cacheFactory, numberOfCollisions));
    }

    private static class ActualIdMapper
    implements IdMapper {
        private ActualIdMapper() {
        }

        @Override
        public void put(Object inputId, long actualId, Group group) {
        }

        @Override
        public boolean needsPreparation() {
            return false;
        }

        @Override
        public void prepare(LongFunction<Object> inputIdLookup, Collector collector, ProgressListener progress) {
        }

        @Override
        public long get(Object inputId, Group group) {
            return (Long)inputId;
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void close() {
        }

        @Override
        public MemoryStatsVisitor.Visitable memoryEstimation(long numberOfNodes) {
            return MemoryStatsVisitor.NONE;
        }

        @Override
        public LongIterator leftOverDuplicateNodesIds() {
            return ImmutableEmptyLongIterator.INSTANCE;
        }
    }
}

