/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.Arrays;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;

public class IdRangeIterator
implements IdSequence {
    public static final IdRangeIterator EMPTY_ID_RANGE_ITERATOR = new IdRangeIterator(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 0)){

        @Override
        public long nextId() {
            return -1L;
        }
    };
    public static final long VALUE_REPRESENTING_NULL = -1L;
    private int position;
    private final long[] defrag;
    private final long start;
    private final int length;

    public IdRangeIterator(IdRange idRange) {
        this.defrag = idRange.getDefragIds();
        this.start = idRange.getRangeStart();
        this.length = idRange.getRangeLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId() {
        try {
            if (this.position < this.defrag.length) {
                long l = this.defrag[this.position];
                return l;
            }
            long candidate = this.nextRangeCandidate();
            if (IdValidator.isReservedId(candidate)) {
                ++this.position;
                candidate = this.nextRangeCandidate();
            }
            long l = candidate;
            return l;
        }
        finally {
            ++this.position;
        }
    }

    @Override
    public IdRange nextIdBatch(int size) {
        int sizeLeft = size;
        long[] rangeDefrag = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        if (this.position < this.defrag.length) {
            int numberOfDefrags = Integer.min(sizeLeft, this.defrag.length - this.position);
            rangeDefrag = Arrays.copyOfRange(this.defrag, this.position, numberOfDefrags + this.position);
            this.position += numberOfDefrags;
            sizeLeft -= numberOfDefrags;
        }
        long rangeStart = 0L;
        int rangeLength = 0;
        int rangeOffset = this.currentRangeOffset();
        int rangeAvailable = this.length - rangeOffset;
        if (sizeLeft > 0 && rangeAvailable > 0) {
            rangeStart = this.start + (long)rangeOffset;
            rangeLength = Integer.min(rangeAvailable, sizeLeft);
            this.position += rangeLength;
        }
        return new IdRange(rangeDefrag, rangeStart, rangeLength);
    }

    private long nextRangeCandidate() {
        int offset = this.currentRangeOffset();
        return offset < this.length ? this.start + (long)offset : -1L;
    }

    private int currentRangeOffset() {
        return this.position - this.defrag.length;
    }

    public String toString() {
        return "IdRangeIterator[start:" + this.start + ", length:" + this.length + ", position:" + this.position + ", defrag:" + Arrays.toString(this.defrag) + "]";
    }
}

