/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import java.time.ZoneId;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.scheduler.JobScheduler;

public final class ConfigurableStandalonePageCacheFactory {
    private ConfigurableStandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, PageCacheTracer.NULL, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, Config.defaults(), EmptyVersionContextSupplier.EMPTY, jobScheduler);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, JobScheduler jobScheduler) {
        return ConfigurableStandalonePageCacheFactory.createPageCache(fileSystem, PageCacheTracer.NULL, (PageCursorTracerSupplier)DefaultPageCursorTracerSupplier.INSTANCE, config, EmptyVersionContextSupplier.EMPTY, jobScheduler);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, Config config, VersionContextSupplier versionContextSupplier, JobScheduler jobScheduler) {
        config.augmentDefaults(GraphDatabaseSettings.pagecache_memory, "8M");
        ZoneId logTimeZone = config.get(GraphDatabaseSettings.db_timezone).getZoneId();
        FormattedLogProvider logProvider = FormattedLogProvider.withZoneId((ZoneId)logTimeZone).toOutputStream((OutputStream)System.err);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, pageCacheTracer, pageCursorTracerSupplier, logProvider.getLog(PageCache.class), versionContextSupplier, jobScheduler);
        return pageCacheFactory.getOrCreatePageCache();
    }
}

