/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.LazyInstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;

class FusionIndexUpdater
extends FusionIndexBase<IndexUpdater>
implements IndexUpdater {
    FusionIndexUpdater(SlotSelector slotSelector, LazyInstanceSelector<IndexUpdater> instanceSelector) {
        super(slotSelector, instanceSelector);
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.beforeValues(), GROUP_OF));
                IndexUpdater to = (IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF));
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.instanceSelector.select(this.slotSelector.selectSlot(update.values(), GROUP_OF))).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IndexEntryConflictException {
        AtomicReference chainedExceptions = new AtomicReference();
        this.instanceSelector.close(indexUpdater -> {
            block2: {
                try {
                    indexUpdater.close();
                }
                catch (IndexEntryConflictException e) {
                    if (chainedExceptions.compareAndSet(null, e)) break block2;
                    ((IndexEntryConflictException)chainedExceptions.get()).addSuppressed(e);
                }
            }
        });
        if (chainedExceptions.get() != null) {
            throw (IndexEntryConflictException)chainedExceptions.get();
        }
    }
}

