/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.DateIndexKey;
import org.neo4j.kernel.impl.index.schema.DateLayout;
import org.neo4j.kernel.impl.index.schema.DurationIndexKey;
import org.neo4j.kernel.impl.index.schema.DurationLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.LocalTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.LocalTimeLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.ZonedDateTimeLayout;
import org.neo4j.kernel.impl.index.schema.ZonedTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.ZonedTimeLayout;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexFiles {
    private final FileSystemAbstraction fs;
    private FileLayout<DateIndexKey> date;
    private FileLayout<LocalDateTimeIndexKey> localDateTime;
    private FileLayout<ZonedDateTimeIndexKey> zonedDateTime;
    private FileLayout<LocalTimeIndexKey> localTime;
    private FileLayout<ZonedTimeIndexKey> zonedTime;
    private FileLayout<DurationIndexKey> duration;

    TemporalIndexFiles(IndexDirectoryStructure directoryStructure, StoreIndexDescriptor descriptor, FileSystemAbstraction fs) {
        this.fs = fs;
        File indexDirectory = directoryStructure.directoryForIndex(descriptor.getId());
        this.date = new FileLayout<DateIndexKey>(new File(indexDirectory, "date"), new DateLayout(), ValueGroup.DATE);
        this.localTime = new FileLayout<LocalTimeIndexKey>(new File(indexDirectory, "localTime"), new LocalTimeLayout(), ValueGroup.LOCAL_TIME);
        this.zonedTime = new FileLayout<ZonedTimeIndexKey>(new File(indexDirectory, "zonedTime"), new ZonedTimeLayout(), ValueGroup.ZONED_TIME);
        this.localDateTime = new FileLayout<LocalDateTimeIndexKey>(new File(indexDirectory, "localDateTime"), new LocalDateTimeLayout(), ValueGroup.LOCAL_DATE_TIME);
        this.zonedDateTime = new FileLayout<ZonedDateTimeIndexKey>(new File(indexDirectory, "zonedDateTime"), new ZonedDateTimeLayout(), ValueGroup.ZONED_DATE_TIME);
        this.duration = new FileLayout<DurationIndexKey>(new File(indexDirectory, "duration"), new DurationLayout(), ValueGroup.DURATION);
    }

    Iterable<FileLayout> existing() {
        ArrayList<FileLayout> existing = new ArrayList<FileLayout>();
        this.addIfExists(existing, this.date);
        this.addIfExists(existing, this.localDateTime);
        this.addIfExists(existing, this.zonedDateTime);
        this.addIfExists(existing, this.localTime);
        this.addIfExists(existing, this.zonedTime);
        this.addIfExists(existing, this.duration);
        return existing;
    }

    <T> void loadExistingIndexes(TemporalIndexCache<T> indexCache) throws IOException {
        for (FileLayout fileLayout : this.existing()) {
            indexCache.select(fileLayout.valueGroup);
        }
    }

    FileLayout<DateIndexKey> date() {
        return this.date;
    }

    FileLayout<LocalTimeIndexKey> localTime() {
        return this.localTime;
    }

    FileLayout<ZonedTimeIndexKey> zonedTime() {
        return this.zonedTime;
    }

    FileLayout<LocalDateTimeIndexKey> localDateTime() {
        return this.localDateTime;
    }

    FileLayout<ZonedDateTimeIndexKey> zonedDateTime() {
        return this.zonedDateTime;
    }

    FileLayout<DurationIndexKey> duration() {
        return this.duration;
    }

    private void addIfExists(List<FileLayout> existing, FileLayout fileLayout) {
        if (this.exists(fileLayout)) {
            existing.add(fileLayout);
        }
    }

    private boolean exists(FileLayout fileLayout) {
        return fileLayout != null && this.fs.fileExists(fileLayout.indexFile);
    }

    static class FileLayout<KEY extends NativeIndexSingleValueKey<KEY>> {
        final File indexFile;
        final IndexLayout<KEY, NativeIndexValue> layout;
        final ValueGroup valueGroup;

        FileLayout(File indexFile, IndexLayout<KEY, NativeIndexValue> layout, ValueGroup valueGroup) {
            this.indexFile = indexFile;
            this.layout = layout;
            this.valueGroup = valueGroup;
        }
    }
}

