/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexLimitation;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.StringIndexAccessor;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringIndexPopulator;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class StringIndexProvider
extends NativeIndexProvider<StringIndexKey, NativeIndexValue, StringLayout> {
    public static final String KEY = "string";
    static final IndexCapability CAPABILITY = new StringIndexCapability();
    private static final IndexProviderDescriptor STRING_PROVIDER_DESCRIPTOR = new IndexProviderDescriptor("string", "1.0");

    public StringIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(STRING_PROVIDER_DESCRIPTOR, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    StringLayout layout(StoreIndexDescriptor descriptor, File storeFile) {
        return new StringLayout();
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, StringLayout layout, StoreIndexDescriptor descriptor, ByteBufferFactory bufferFactory) {
        return new WorkSyncedNativeIndexPopulator<StringIndexKey, NativeIndexValue>(new StringIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor));
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, StringLayout layout, StoreIndexDescriptor descriptor) throws IOException {
        return new StringIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor);
    }

    @Override
    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return CAPABILITY;
    }

    private static class StringIndexCapability
    implements IndexCapability {
        private final IndexLimitation[] limitations = new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};

        private StringIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return ORDER_BOTH;
            }
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueCategories)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        public boolean isFulltextIndex() {
            return false;
        }

        public boolean isEventuallyConsistent() {
            return false;
        }

        public IndexLimitation[] limitations() {
            return this.limitations;
        }

        private boolean support(ValueCategory[] valueCategories) {
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEXT;
        }
    }
}

