/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Arrays;
import java.util.StringJoiner;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.stack.mutable.primitive.IntArrayStack;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.util.VisibleForTesting;

public class TreeNodeDynamicSize<KEY, VALUE>
extends TreeNode<KEY, VALUE> {
    static final byte FORMAT_IDENTIFIER = 3;
    static final byte FORMAT_VERSION = 0;
    private static final int BYTE_POS_ALLOCOFFSET = 82;
    private static final int BYTE_POS_DEADSPACE = 82 + TreeNodeDynamicSize.bytesPageOffset();
    private static final int HEADER_LENGTH_DYNAMIC = BYTE_POS_DEADSPACE + TreeNodeDynamicSize.bytesPageOffset();
    private static final int LEAST_NUMBER_OF_ENTRIES_PER_PAGE = 2;
    private static final int MINIMUM_ENTRY_SIZE_CAP = 64;
    private final int keyValueSizeCap;
    private final MutableIntStack deadKeysOffset = new IntArrayStack();
    private final MutableIntStack aliveKeysOffset = new IntArrayStack();
    private final int maxKeyCount = this.pageSize / (TreeNodeDynamicSize.bytesKeyOffset() + 2 + 2);
    private final int[] oldOffset = new int[this.maxKeyCount];
    private final int[] newOffset = new int[this.maxKeyCount];
    private final int totalSpace;
    private final int halfSpace;
    private final KEY tmpKeyLeft;
    private final KEY tmpKeyRight;

    TreeNodeDynamicSize(int pageSize, Layout<KEY, VALUE> layout) {
        super(pageSize, layout);
        this.totalSpace = pageSize - HEADER_LENGTH_DYNAMIC;
        this.halfSpace = this.totalSpace / 2;
        this.keyValueSizeCap = TreeNodeDynamicSize.keyValueSizeCapFromPageSize(pageSize);
        if (this.keyValueSizeCap < 64) {
            throw new MetadataMismatchException("We need to fit at least %d key-value entries per page in leaves. To do that a key-value entry can be at most %dB with current page size of %dB. We require this cap to be at least %dB.", 2, this.keyValueSizeCap, pageSize, 64);
        }
        this.tmpKeyLeft = layout.newKey();
        this.tmpKeyRight = layout.newKey();
    }

    @VisibleForTesting
    public static int keyValueSizeCapFromPageSize(int pageSize) {
        return (pageSize - HEADER_LENGTH_DYNAMIC) / 2 - 6;
    }

    @Override
    void writeAdditionalHeader(PageCursor cursor) {
        this.setAllocOffset(cursor, this.pageSize);
        this.setDeadSpace(cursor, 0);
    }

    @Override
    KEY keyAt(PageCursor cursor, KEY into, int pos, TreeNode.Type type) {
        this.placeCursorAtActualKey(cursor, pos, type);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0) {
            this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
            return into;
        }
        this.layout.readKey(cursor, into, keySize);
        return into;
    }

    @Override
    void keyValueAt(PageCursor cursor, KEY intoKey, VALUE intoValue, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0 || valueSize < 0) {
            this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
            return;
        }
        this.layout.readKey(cursor, intoKey, keySize);
        this.layout.readValue(cursor, intoValue, valueSize);
    }

    @Override
    void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration) {
        int currentKeyOffset = this.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        int newKeyOffset = currentKeyOffset - keySize - DynamicSizeUtil.getOverhead(keySize, 0);
        cursor.setOffset(newKeyOffset);
        DynamicSizeUtil.putKeySize(cursor, keySize);
        this.layout.writeKey(cursor, key);
        this.setAllocOffset(cursor, newKeyOffset);
        TreeNodeDynamicSize.insertSlotsAt(cursor, pos, 1, keyCount, this.keyPosOffsetInternal(0), this.keyChildSize());
        cursor.setOffset(this.keyPosOffsetInternal(pos));
        DynamicSizeUtil.putKeyOffset(cursor, newKeyOffset);
        TreeNodeDynamicSize.writeChild(cursor, child, stableGeneration, unstableGeneration);
    }

    @Override
    void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount) {
        int currentKeyValueOffset = this.getAllocOffset(cursor);
        int keySize = this.layout.keySize(key);
        int valueSize = this.layout.valueSize(value);
        int newKeyValueOffset = currentKeyValueOffset - keySize - valueSize - DynamicSizeUtil.getOverhead(keySize, valueSize);
        cursor.setOffset(newKeyValueOffset);
        DynamicSizeUtil.putKeyValueSize(cursor, keySize, valueSize);
        this.layout.writeKey(cursor, key);
        this.layout.writeValue(cursor, value);
        this.setAllocOffset(cursor, newKeyValueOffset);
        TreeNodeDynamicSize.insertSlotsAt(cursor, pos, 1, keyCount, this.keyPosOffsetLeaf(0), TreeNodeDynamicSize.bytesKeyOffset());
        cursor.setOffset(this.keyPosOffsetLeaf(pos));
        DynamicSizeUtil.putKeyOffset(cursor, newKeyValueOffset);
    }

    @Override
    void removeKeyValueAt(PageCursor cursor, int pos, int keyCount) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        int keyOffset = cursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize));
        TreeNodeDynamicSize.removeSlotAt(cursor, pos, keyCount, this.keyPosOffsetLeaf(0), TreeNodeDynamicSize.bytesKeyOffset());
    }

    @Override
    void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount) {
        this.placeCursorAtActualKey(cursor, keyPos, TreeNode.Type.INTERNAL);
        int keyOffset = cursor.getOffset();
        int keySize = DynamicSizeUtil.extractKeySize(DynamicSizeUtil.readKeyValueSize(cursor));
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0));
        TreeNodeDynamicSize.removeSlotAt(cursor, keyPos, keyCount, this.keyPosOffsetInternal(0), this.keyChildSize());
        this.zeroPad(cursor, this.keyPosOffsetInternal(keyCount - 1), TreeNodeDynamicSize.bytesKeyOffset() + this.childSize());
    }

    @Override
    void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount) {
        this.placeCursorAtActualKey(cursor, keyPos, TreeNode.Type.INTERNAL);
        int keyOffset = cursor.getOffset();
        int keySize = DynamicSizeUtil.extractKeySize(DynamicSizeUtil.readKeyValueSize(cursor));
        cursor.setOffset(keyOffset);
        DynamicSizeUtil.putTombstone(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        this.setDeadSpace(cursor, deadSpace + keySize + DynamicSizeUtil.getOverhead(keySize, 0));
        TreeNodeDynamicSize.removeSlotAt(cursor, keyPos, keyCount, this.keyPosOffsetInternal(0) - this.childSize(), this.keyChildSize());
        cursor.copyTo(this.childOffset(keyCount), cursor, this.childOffset(keyCount - 1), this.childSize());
        this.zeroPad(cursor, this.keyPosOffsetInternal(keyCount - 1), TreeNodeDynamicSize.bytesKeyOffset() + this.childSize());
    }

    @Override
    boolean setKeyAtInternal(PageCursor cursor, KEY key, int pos) {
        int newKeySize;
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.INTERNAL);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int oldKeySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(oldKeySize, oldValueSize)) {
            this.readUnreliableKeyValueSize(cursor, oldKeySize, oldValueSize, keyValueSize, pos);
        }
        if ((newKeySize = this.layout.keySize(key)) == oldKeySize) {
            this.layout.writeKey(cursor, key);
            return true;
        }
        return false;
    }

    @Override
    VALUE valueAt(PageCursor cursor, VALUE into, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        if (this.keyValueSizeTooLarge(keySize, valueSize) || keySize < 0 || valueSize < 0) {
            this.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos);
            return into;
        }
        this.progressCursor(cursor, keySize);
        this.layout.readValue(cursor, into, valueSize);
        return into;
    }

    @Override
    boolean setValueAt(PageCursor cursor, VALUE value, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int oldValueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        int newValueSize = this.layout.valueSize(value);
        if (oldValueSize == newValueSize) {
            this.progressCursor(cursor, keySize);
            this.layout.writeValue(cursor, value);
            return true;
        }
        return false;
    }

    private void progressCursor(PageCursor cursor, int delta) {
        cursor.setOffset(cursor.getOffset() + delta);
    }

    @Override
    void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(this.childOffset(pos));
        TreeNodeDynamicSize.writeChild(cursor, child, stableGeneration, unstableGeneration);
    }

    @Override
    public int keyValueSizeCap() {
        return this.keyValueSizeCap;
    }

    @Override
    void validateKeyValueSize(KEY key, VALUE value) {
        int valueSize;
        int keySize = this.layout.keySize(key);
        if (this.keyValueSizeTooLarge(keySize, valueSize = this.layout.valueSize(value))) {
            throw new IllegalArgumentException("Index key-value size it to large. Please see index documentation for limitations.");
        }
    }

    @Override
    boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.totalSpace / 6;
    }

    @Override
    boolean reasonableChildCount(int childCount) {
        return this.reasonableKeyCount(childCount);
    }

    @Override
    int childOffset(int pos) {
        return this.keyPosOffsetInternal(pos) - this.childSize();
    }

    @Override
    TreeNode.Overflow internalOverflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        int allocSpace = this.getAllocSpace(cursor, currentKeyCount, TreeNode.Type.INTERNAL);
        int deadSpace = this.getDeadSpace(cursor);
        int neededSpace = this.totalSpaceOfKeyChild(newKey);
        return neededSpace <= allocSpace ? TreeNode.Overflow.NO : (neededSpace <= allocSpace + deadSpace ? TreeNode.Overflow.NO_NEED_DEFRAG : TreeNode.Overflow.YES);
    }

    @Override
    TreeNode.Overflow leafOverflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        int deadSpace = this.getDeadSpace(cursor);
        int allocSpace = this.getAllocSpace(cursor, currentKeyCount, TreeNode.Type.LEAF);
        int neededSpace = this.totalSpaceOfKeyValue(newKey, newValue);
        return neededSpace <= allocSpace ? TreeNode.Overflow.NO : (neededSpace <= allocSpace + deadSpace ? TreeNode.Overflow.NO_NEED_DEFRAG : TreeNode.Overflow.YES);
    }

    @Override
    void defragmentLeaf(PageCursor cursor) {
        this.doDefragment(cursor, TreeNode.Type.LEAF);
    }

    @Override
    void defragmentInternal(PageCursor cursor) {
        this.doDefragment(cursor, TreeNode.Type.INTERNAL);
    }

    private void doDefragment(PageCursor cursor, TreeNode.Type type) {
        this.deadKeysOffset.clear();
        this.aliveKeysOffset.clear();
        if (type == TreeNode.Type.INTERNAL) {
            this.recordDeadAndAliveInternal(cursor, this.deadKeysOffset, this.aliveKeysOffset);
        } else {
            this.recordDeadAndAliveLeaf(cursor, this.deadKeysOffset, this.aliveKeysOffset);
        }
        int oldOffsetCursor = 0;
        int newOffsetCursor = 0;
        int aliveRangeOffset = this.pageSize;
        while (TreeNodeDynamicSize.peek((IntStack)this.deadKeysOffset) < TreeNodeDynamicSize.peek((IntStack)this.aliveKeysOffset)) {
            aliveRangeOffset = TreeNodeDynamicSize.poll(this.aliveKeysOffset);
        }
        do {
            int deadRangeOffset = aliveRangeOffset;
            while (TreeNodeDynamicSize.peek((IntStack)this.aliveKeysOffset) < TreeNodeDynamicSize.peek((IntStack)this.deadKeysOffset)) {
                deadRangeOffset = TreeNodeDynamicSize.poll(this.deadKeysOffset);
            }
            int moveOffset = deadRangeOffset;
            while (TreeNodeDynamicSize.peek((IntStack)this.deadKeysOffset) < TreeNodeDynamicSize.peek((IntStack)this.aliveKeysOffset)) {
                int moveKey = TreeNodeDynamicSize.poll(this.aliveKeysOffset);
                this.oldOffset[oldOffsetCursor++] = moveKey;
                moveOffset = moveKey;
            }
            int deadRangeSize = aliveRangeOffset - deadRangeOffset;
            while (oldOffsetCursor > newOffsetCursor) {
                this.newOffset[newOffsetCursor] = this.oldOffset[newOffsetCursor] + deadRangeSize;
                ++newOffsetCursor;
            }
            while (moveOffset < deadRangeOffset - deadRangeSize) {
                cursor.copyTo(deadRangeOffset -= deadRangeSize, cursor, aliveRangeOffset -= deadRangeSize, deadRangeSize);
            }
            int lastBlockSize = deadRangeOffset - moveOffset;
            if (lastBlockSize <= 0) continue;
            cursor.copyTo(deadRangeOffset -= lastBlockSize, cursor, aliveRangeOffset -= lastBlockSize, lastBlockSize);
        } while (!this.aliveKeysOffset.isEmpty());
        int prevAllocOffset = this.getAllocOffset(cursor);
        this.setAllocOffset(cursor, aliveRangeOffset);
        this.zeroPad(cursor, prevAllocOffset, aliveRangeOffset - prevAllocOffset);
        int keyCount = TreeNodeDynamicSize.keyCount(cursor);
        block6: for (int pos = 0; pos < keyCount; ++pos) {
            int keyPosOffset = this.keyPosOffset(pos, type);
            cursor.setOffset(keyPosOffset);
            int keyOffset = DynamicSizeUtil.readKeyOffset(cursor);
            for (int index = 0; index < oldOffsetCursor; ++index) {
                if (keyOffset != this.oldOffset[index]) continue;
                cursor.setOffset(keyPosOffset);
                DynamicSizeUtil.putKeyOffset(cursor, this.newOffset[index]);
                continue block6;
            }
        }
        this.setDeadSpace(cursor, 0);
    }

    private static int peek(IntStack stack) {
        return stack.isEmpty() ? -1 : stack.peek();
    }

    private static int poll(MutableIntStack stack) {
        return stack.isEmpty() ? -1 : stack.pop();
    }

    @Override
    boolean leafUnderflow(PageCursor cursor, int keyCount) {
        int deadSpace;
        int halfSpace = this.halfSpace;
        int allocSpace = this.getAllocSpace(cursor, keyCount, TreeNode.Type.LEAF);
        int availableSpace = allocSpace + (deadSpace = this.getDeadSpace(cursor));
        return availableSpace > halfSpace;
    }

    @Override
    int canRebalanceLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int prevDelta;
        int lastChunkSize;
        int rightActiveSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount, TreeNode.Type.LEAF);
        if (leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount, TreeNode.Type.LEAF)) < this.totalSpace) {
            return -1;
        }
        if (leftActiveSpace < rightActiveSpace) {
            return 0;
        }
        int currentDelta = Math.abs(leftActiveSpace - rightActiveSpace);
        int keysToMove = 0;
        do {
            lastChunkSize = this.totalSpaceOfKeyValue(leftCursor, leftKeyCount - ++keysToMove);
            prevDelta = currentDelta;
        } while ((currentDelta = Math.abs((leftActiveSpace -= lastChunkSize) - (rightActiveSpace += lastChunkSize))) < prevDelta);
        int halfSpace = this.halfSpace;
        boolean canRebalance = (leftActiveSpace += lastChunkSize) > halfSpace && (rightActiveSpace -= lastChunkSize) > halfSpace;
        return canRebalance ? --keysToMove : 0;
    }

    @Override
    boolean canMergeLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        int rightActiveSpace;
        int totalSpace = this.totalSpace;
        int leftActiveSpace = this.totalActiveSpace(leftCursor, leftKeyCount, TreeNode.Type.LEAF);
        return totalSpace >= leftActiveSpace + (rightActiveSpace = this.totalActiveSpace(rightCursor, rightKeyCount, TreeNode.Type.LEAF));
    }

    @Override
    void doSplitLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, double ratioToKeepInLeftOnSplit) {
        KEY rightInSplit;
        KEY leftInSplit;
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = this.splitPosInLeaf(leftCursor, insertPos, newKey, newValue, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            leftInSplit = this.keyAt(leftCursor, this.tmpKeyLeft, splitPos - 1, TreeNode.Type.LEAF);
            rightInSplit = newKey;
        } else {
            int rightPos = insertPos < splitPos ? splitPos - 1 : splitPos;
            rightInSplit = this.keyAt(leftCursor, this.tmpKeyRight, rightPos, TreeNode.Type.LEAF);
            if (rightPos == insertPos) {
                leftInSplit = newKey;
            } else {
                int leftPos = rightPos - 1;
                leftInSplit = this.keyAt(leftCursor, this.tmpKeyLeft, leftPos, TreeNode.Type.LEAF);
            }
        }
        this.layout.minimalSplitter(leftInSplit, rightInSplit, newSplitter);
        int rightKeyCount = keyCountAfterInsert - splitPos;
        if (insertPos < splitPos) {
            this.moveKeysAndValues(leftCursor, splitPos - 1, rightCursor, 0, rightKeyCount);
            this.defragmentLeaf(leftCursor);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, splitPos - 1);
        } else {
            int newInsertPos = insertPos - splitPos;
            int keysToMove = leftKeyCount - splitPos;
            this.moveKeysAndValues(leftCursor, splitPos, rightCursor, 0, keysToMove);
            this.defragmentLeaf(leftCursor);
            this.insertKeyValueAt(rightCursor, newKey, newValue, newInsertPos, keysToMove);
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void doSplitInternal(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit) {
        int keyCountAfterInsert = leftKeyCount + 1;
        int splitPos = this.splitPosInternal(leftCursor, insertPos, newKey, keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(leftCursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, TreeNode.Type.INTERNAL);
        }
        int rightKeyCount = keyCountAfterInsert - splitPos - 1;
        if (insertPos < splitPos) {
            this.moveKeysAndChildren(leftCursor, splitPos, rightCursor, 0, rightKeyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos - 1, splitPos);
            this.defragmentInternal(leftCursor);
            this.insertKeyAndRightChildAt(leftCursor, newKey, newRightChild, insertPos, splitPos - 1, stableGeneration, unstableGeneration);
        } else if (insertPos == splitPos) {
            int copyFrom = splitPos;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, false);
            this.defragmentInternal(leftCursor);
            this.setChildAt(rightCursor, newRightChild, 0, stableGeneration, unstableGeneration);
        } else {
            int copyFrom = splitPos + 1;
            int copyCount = leftKeyCount - copyFrom;
            this.moveKeysAndChildren(leftCursor, copyFrom, rightCursor, 0, copyCount, true);
            this.removeKeyAndRightChildAt(leftCursor, splitPos, splitPos + 1);
            this.defragmentInternal(leftCursor);
            this.insertKeyAndRightChildAt(rightCursor, newKey, newRightChild, insertPos - copyFrom, copyCount, stableGeneration, unstableGeneration);
        }
        TreeNode.setKeyCount(leftCursor, splitPos);
        TreeNode.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        this.defragmentLeaf(rightCursor);
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        TreeNodeDynamicSize.insertSlotsAt(rightCursor, 0, numberOfKeysToMove, rightKeyCount, this.keyPosOffsetLeaf(0), TreeNodeDynamicSize.bytesKeyOffset());
        this.moveKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeDynamicSize.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    private void moveKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int firstAllocOffset;
        int toAllocOffset = firstAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.moveRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset);
            toCursor.setOffset(this.keyPosOffsetLeaf(toPos));
            DynamicSizeUtil.putKeyOffset(toCursor, toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = this.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        this.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        TreeNodeDynamicSize.setKeyCount(fromCursor, fromPos);
    }

    private int moveRawKeyValue(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset) {
        this.placeCursorAtActualKey(fromCursor, fromPos, TreeNode.Type.LEAF);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, valueSize) + keySize + valueSize;
        int newRightAllocSpace = toAllocOffset - toCopy;
        fromCursor.copyTo(fromKeyOffset, toCursor, newRightAllocSpace, toCopy);
        fromCursor.setOffset(fromKeyOffset);
        DynamicSizeUtil.putTombstone(fromCursor);
        return newRightAllocSpace;
    }

    @Override
    void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.defragmentLeaf(rightCursor);
        TreeNodeDynamicSize.insertSlotsAt(rightCursor, 0, leftKeyCount, rightKeyCount, this.keyPosOffsetLeaf(0), TreeNodeDynamicSize.bytesKeyOffset());
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeDynamicSize.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        int toAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.copyRawKeyValue(fromCursor, fromPos + i, toCursor, toAllocOffset);
            toCursor.setOffset(this.keyPosOffsetLeaf(toPos));
            DynamicSizeUtil.putKeyOffset(toCursor, toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
    }

    private int copyRawKeyValue(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset) {
        this.placeCursorAtActualKey(fromCursor, fromPos, TreeNode.Type.LEAF);
        int fromKeyOffset = fromCursor.getOffset();
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(fromCursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        int toCopy = DynamicSizeUtil.getOverhead(keySize, valueSize) + keySize + valueSize;
        int newRightAllocSpace = toAllocOffset - toCopy;
        fromCursor.copyTo(fromKeyOffset, toCursor, newRightAllocSpace, toCopy);
        return newRightAllocSpace;
    }

    private int getAllocSpace(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int allocOffset = this.getAllocOffset(cursor);
        int endOfOffsetArray = type == TreeNode.Type.LEAF ? this.keyPosOffsetLeaf(keyCount) : this.keyPosOffsetInternal(keyCount);
        return allocOffset - endOfOffsetArray;
    }

    private void recordDeadAndAliveLeaf(PageCursor cursor, MutableIntStack deadKeysOffset, MutableIntStack aliveKeysOffset) {
        int valueSize;
        int keySize;
        for (int currentOffset = this.getAllocOffset(cursor); currentOffset < this.pageSize; currentOffset += keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize)) {
            cursor.setOffset(currentOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean dead = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (dead) {
                deadKeysOffset.push(currentOffset);
                continue;
            }
            aliveKeysOffset.push(currentOffset);
        }
    }

    private void recordDeadAndAliveInternal(PageCursor cursor, MutableIntStack deadKeysOffset, MutableIntStack aliveKeysOffset) {
        int keySize;
        for (int currentOffset = this.getAllocOffset(cursor); currentOffset < this.pageSize; currentOffset += keySize + DynamicSizeUtil.getOverhead(keySize, 0)) {
            cursor.setOffset(currentOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            boolean dead = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (dead) {
                deadKeysOffset.push(currentOffset);
                continue;
            }
            aliveKeysOffset.push(currentOffset);
        }
    }

    private void moveKeysAndChildren(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count, boolean includeLeftMostChild) {
        int toAllocOffset;
        if (count == 0 && !includeLeftMostChild) {
            return;
        }
        int childFromOffset = includeLeftMostChild ? this.childOffset(fromPos) : this.childOffset(fromPos + 1);
        int childToOffset = this.childOffset(fromPos + count) + this.childSize();
        int lengthInBytes = childToOffset - childFromOffset;
        int targetOffset = includeLeftMostChild ? this.childOffset(0) : this.childOffset(1);
        fromCursor.copyTo(childFromOffset, toCursor, targetOffset, lengthInBytes);
        int firstAllocOffset = toAllocOffset = this.getAllocOffset(toCursor);
        int i = 0;
        while (i < count) {
            toAllocOffset = this.transferRawKey(fromCursor, fromPos + i, toCursor, toAllocOffset);
            toCursor.setOffset(this.keyPosOffsetInternal(toPos));
            DynamicSizeUtil.putKeyOffset(toCursor, toAllocOffset);
            ++i;
            ++toPos;
        }
        this.setAllocOffset(toCursor, toAllocOffset);
        int deadSpace = this.getDeadSpace(fromCursor);
        int totalMovedBytes = firstAllocOffset - toAllocOffset;
        this.setDeadSpace(fromCursor, deadSpace + totalMovedBytes);
        this.zeroPad(fromCursor, childFromOffset, lengthInBytes);
    }

    private void zeroPad(PageCursor fromCursor, int fromOffset, int lengthInBytes) {
        fromCursor.setOffset(fromOffset);
        fromCursor.putBytes(lengthInBytes, (byte)0);
    }

    private int transferRawKey(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toAllocOffset) {
        this.placeCursorAtActualKey(fromCursor, fromPos, TreeNode.Type.INTERNAL);
        int fromKeyOffset = fromCursor.getOffset();
        int keySize = DynamicSizeUtil.extractKeySize(DynamicSizeUtil.readKeyValueSize(fromCursor));
        int toCopy = DynamicSizeUtil.getOverhead(keySize, 0) + keySize;
        fromCursor.copyTo(fromKeyOffset, toCursor, toAllocOffset -= toCopy, toCopy);
        fromCursor.setOffset(fromKeyOffset);
        DynamicSizeUtil.putTombstone(fromCursor);
        return toAllocOffset;
    }

    private int splitPosInternal(PageCursor cursor, int insertPos, KEY newKey, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = this.childSize();
        int currentDelta = Math.abs(accumulatedLeftSpace - targetLeftSpace);
        int spaceOfNewKeyAndChild = this.totalSpaceOfKeyChild(newKey);
        int totalSpaceIncludingNewKeyAndChild = this.totalActiveSpace(cursor, keyCountAfterInsert - 1, TreeNode.Type.INTERNAL) + spaceOfNewKeyAndChild;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        do {
            int space;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos & !includedNew) {
                space = this.totalSpaceOfKeyChild(newKey);
                includedNew = true;
                --currentPos;
            } else {
                space = this.totalSpaceOfKeyChild(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += space) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKeyAndChild - accumulatedLeftSpace < this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace < this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int splitPosInLeaf(PageCursor cursor, int insertPos, KEY newKey, VALUE newValue, int keyCountAfterInsert, double ratioToKeepInLeftOnSplit) {
        boolean prevPosPossible;
        int prevDelta;
        int targetLeftSpace = (int)((double)this.totalSpace * ratioToKeepInLeftOnSplit);
        int splitPos = 0;
        int currentPos = 0;
        int accumulatedLeftSpace = 0;
        int currentDelta = targetLeftSpace;
        int spaceOfNewKey = this.totalSpaceOfKeyValue(newKey, newValue);
        int totalSpaceIncludingNewKey = this.totalActiveSpace(cursor, keyCountAfterInsert - 1, TreeNode.Type.LEAF) + spaceOfNewKey;
        boolean includedNew = false;
        boolean thisPosPossible = false;
        if (totalSpaceIncludingNewKey > this.totalSpace * 2) {
            throw new IllegalStateException(String.format("There's not enough space to insert new key, even when splitting the leaf. Space needed:%d, max space allowed:%d", totalSpaceIncludingNewKey, this.totalSpace * 2));
        }
        do {
            int currentSpace;
            prevPosPossible = thisPosPossible;
            if (currentPos == insertPos & !includedNew) {
                currentSpace = spaceOfNewKey;
                includedNew = true;
                --currentPos;
            } else {
                currentSpace = this.totalSpaceOfKeyValue(cursor, currentPos);
            }
            prevDelta = currentDelta;
            currentDelta = Math.abs((accumulatedLeftSpace += currentSpace) - targetLeftSpace);
            ++currentPos;
            boolean bl = thisPosPossible = totalSpaceIncludingNewKey - accumulatedLeftSpace <= this.totalSpace;
        } while (currentDelta < prevDelta && ++splitPos < keyCountAfterInsert && accumulatedLeftSpace <= this.totalSpace || !thisPosPossible);
        if (prevPosPossible) {
            --splitPos;
        }
        return splitPos;
    }

    private int totalActiveSpace(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int deadSpace = this.getDeadSpace(cursor);
        int allocSpace = this.getAllocSpace(cursor, keyCount, type);
        return this.totalSpace - deadSpace - allocSpace;
    }

    private int totalSpaceOfKeyValue(KEY key, VALUE value) {
        int keySize = this.layout.keySize(key);
        int valueSize = this.layout.valueSize(value);
        return TreeNodeDynamicSize.bytesKeyOffset() + DynamicSizeUtil.getOverhead(keySize, valueSize) + keySize + valueSize;
    }

    private int totalSpaceOfKeyChild(KEY key) {
        int keySize = this.layout.keySize(key);
        return TreeNodeDynamicSize.bytesKeyOffset() + DynamicSizeUtil.getOverhead(keySize, 0) + this.childSize() + keySize;
    }

    private int totalSpaceOfKeyValue(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.LEAF);
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
        int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
        return TreeNodeDynamicSize.bytesKeyOffset() + DynamicSizeUtil.getOverhead(keySize, valueSize) + keySize + valueSize;
    }

    private int totalSpaceOfKeyChild(PageCursor cursor, int pos) {
        this.placeCursorAtActualKey(cursor, pos, TreeNode.Type.INTERNAL);
        int keySize = DynamicSizeUtil.extractKeySize(DynamicSizeUtil.readKeyValueSize(cursor));
        return TreeNodeDynamicSize.bytesKeyOffset() + DynamicSizeUtil.getOverhead(keySize, 0) + this.childSize() + keySize;
    }

    private void setAllocOffset(PageCursor cursor, int allocOffset) {
        PageCursorUtil.putUnsignedShort(cursor, 82, allocOffset);
    }

    int getAllocOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor, 82);
    }

    private void setDeadSpace(PageCursor cursor, int deadSpace) {
        PageCursorUtil.putUnsignedShort(cursor, BYTE_POS_DEADSPACE, deadSpace);
    }

    private int getDeadSpace(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor, BYTE_POS_DEADSPACE);
    }

    private void placeCursorAtActualKey(PageCursor cursor, int pos, TreeNode.Type type) {
        int keyPosOffset = this.keyPosOffset(pos, type);
        cursor.setOffset(keyPosOffset);
        int keyOffset = DynamicSizeUtil.readKeyOffset(cursor);
        if (keyOffset >= this.pageSize || keyOffset < HEADER_LENGTH_DYNAMIC) {
            cursor.setCursorException(String.format("Tried to read key on offset=%d, headerLength=%d, pageSize=%d, pos=%d", keyOffset, HEADER_LENGTH_DYNAMIC, this.pageSize, pos));
            return;
        }
        cursor.setOffset(keyOffset);
    }

    private void readUnreliableKeyValueSize(PageCursor cursor, int keySize, int valueSize, long keyValueSize, int pos) {
        cursor.setCursorException(String.format("Read unreliable key, id=%d, keySize=%d, valueSize=%d, keyValueSizeCap=%d, keyHasTombstone=%b, pos=%d", cursor.getCurrentPageId(), keySize, valueSize, this.keyValueSizeCap(), DynamicSizeUtil.extractTombstone(keyValueSize), pos));
    }

    private boolean keyValueSizeTooLarge(int keySize, int valueSize) {
        return keySize + valueSize > this.keyValueSizeCap();
    }

    private int keyPosOffset(int pos, TreeNode.Type type) {
        if (type == TreeNode.Type.LEAF) {
            return this.keyPosOffsetLeaf(pos);
        }
        return this.keyPosOffsetInternal(pos);
    }

    private int keyPosOffsetLeaf(int pos) {
        return HEADER_LENGTH_DYNAMIC + pos * TreeNodeDynamicSize.bytesKeyOffset();
    }

    private int keyPosOffsetInternal(int pos) {
        return HEADER_LENGTH_DYNAMIC + this.childSize() + pos * this.keyChildSize();
    }

    private int keyChildSize() {
        return TreeNodeDynamicSize.bytesKeyOffset() + 24;
    }

    private int childSize() {
        return 24;
    }

    private static int bytesKeyOffset() {
        return 2;
    }

    private static int bytesPageOffset() {
        return 2;
    }

    public String toString() {
        return "TreeNodeDynamicSize[pageSize:" + this.pageSize + ", keyValueSizeCap:" + this.keyValueSizeCap() + "]";
    }

    private String asString(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration) {
        int currentOffset = cursor.getOffset();
        TreeNode.Type type = TreeNodeDynamicSize.isInternal(cursor) ? TreeNode.Type.INTERNAL : TreeNode.Type.LEAF;
        int allocOffset = this.getAllocOffset(cursor);
        int deadSpace = this.getDeadSpace(cursor);
        String additionalHeader = "{" + cursor.getCurrentPageId() + "} [allocOffset=" + allocOffset + " deadSpace=" + deadSpace + "] ";
        String offsetArray = this.readOffsetArray(cursor, stableGeneration, unstableGeneration, type);
        String allocSpace = "";
        if (includeAllocSpace) {
            allocSpace = this.readAllocSpace(cursor, allocOffset, type);
        }
        Object readKey = this.layout.newKey();
        Object readValue = this.layout.newValue();
        StringJoiner keys = new StringJoiner(" ");
        cursor.setOffset(allocOffset);
        while (cursor.getOffset() < cursor.getCurrentPageSize()) {
            StringJoiner singleKey = new StringJoiner("|");
            singleKey.add(Integer.toString(cursor.getOffset()));
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = 0;
            if (type == TreeNode.Type.LEAF) {
                valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            }
            if (DynamicSizeUtil.extractTombstone(keyValueSize)) {
                singleKey.add("X");
            } else {
                singleKey.add("_");
            }
            this.layout.readKey(cursor, readKey, keySize);
            if (type == TreeNode.Type.LEAF) {
                this.layout.readValue(cursor, readValue, valueSize);
            }
            singleKey.add(Integer.toString(keySize));
            if (type == TreeNode.Type.LEAF && includeValue) {
                singleKey.add(Integer.toString(valueSize));
            }
            singleKey.add(readKey.toString());
            if (type == TreeNode.Type.LEAF && includeValue) {
                singleKey.add(readValue.toString());
            }
            keys.add(singleKey.toString());
        }
        cursor.setOffset(currentOffset);
        return additionalHeader + offsetArray + " " + allocSpace + " " + keys;
    }

    @Override
    void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration) {
        System.out.println(this.asString(cursor, includeValue, includeAllocSpace, stableGeneration, unstableGeneration));
    }

    @Override
    void checkMetaConsistency(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int offsetArray;
        int allocOffset;
        int allocSpace;
        int deadSpace;
        long nodeId = cursor.getCurrentPageId();
        StringJoiner joiner = new StringJoiner(", ", "Inconsistent node, id=" + nodeId + ": ", "");
        boolean hasInconsistency = false;
        int activeSpace = this.totalActiveSpaceRaw(cursor, keyCount, type);
        if (activeSpace + (deadSpace = this.getDeadSpace(cursor)) + (allocSpace = this.getAllocSpace(cursor, keyCount, type)) != this.totalSpace) {
            hasInconsistency = true;
            joiner.add(String.format("Space areas did not sum to total space; activeSpace=%d, deadSpace=%d, allocSpace=%d, totalSpace=%d", activeSpace, deadSpace, allocSpace, this.totalSpace));
        }
        if ((allocOffset = this.getAllocOffset(cursor)) < (offsetArray = this.keyPosOffset(keyCount, type))) {
            hasInconsistency = true;
            joiner.add(String.format("Overlap between offsetArray and allocSpace, offsetArray=%d, allocOffset=%d", offsetArray, allocOffset));
        }
        if (hasInconsistency) {
            cursor.setCursorException(joiner.toString());
        }
    }

    private int totalActiveSpaceRaw(PageCursor cursor, int keyCount, TreeNode.Type type) {
        int offsetArrayStart = HEADER_LENGTH_DYNAMIC;
        int offsetArrayEnd = this.keyPosOffset(keyCount, type);
        int offsetArraySize = offsetArrayEnd - offsetArrayStart;
        int aliveKeySize = 0;
        int nextKeyOffset = this.getAllocOffset(cursor);
        while (nextKeyOffset < this.pageSize) {
            cursor.setOffset(nextKeyOffset);
            long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            int valueSize = DynamicSizeUtil.extractValueSize(keyValueSize);
            boolean tombstone = DynamicSizeUtil.extractTombstone(keyValueSize);
            if (!tombstone) {
                aliveKeySize += DynamicSizeUtil.getOverhead(keySize, valueSize) + keySize + valueSize;
            }
            nextKeyOffset = cursor.getOffset() + keySize + valueSize;
        }
        return offsetArraySize + aliveKeySize;
    }

    private String readAllocSpace(PageCursor cursor, int allocOffset, TreeNode.Type type) {
        int keyCount = TreeNodeDynamicSize.keyCount(cursor);
        int endOfOffsetArray = type == TreeNode.Type.INTERNAL ? this.keyPosOffsetInternal(keyCount) : this.keyPosOffsetLeaf(keyCount);
        cursor.setOffset(endOfOffsetArray);
        int bytesToRead = allocOffset - endOfOffsetArray;
        byte[] allocSpace = new byte[bytesToRead];
        cursor.getBytes(allocSpace);
        for (byte b : allocSpace) {
            if (b == 0) continue;
            return "v" + endOfOffsetArray + ">" + bytesToRead + "|" + Arrays.toString(allocSpace);
        }
        return "v" + endOfOffsetArray + ">" + bytesToRead + "|[0...]";
    }

    private String readOffsetArray(PageCursor cursor, long stableGeneration, long unstableGeneration, TreeNode.Type type) {
        int keyCount = TreeNodeDynamicSize.keyCount(cursor);
        StringJoiner offsetArray = new StringJoiner(" ");
        for (int i = 0; i < keyCount; ++i) {
            if (type == TreeNode.Type.INTERNAL) {
                long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, i, stableGeneration, unstableGeneration));
                offsetArray.add("/" + Long.toString(childPointer) + "\\");
            }
            cursor.setOffset(this.keyPosOffset(i, type));
            offsetArray.add(Integer.toString(DynamicSizeUtil.readKeyOffset(cursor)));
        }
        if (type == TreeNode.Type.INTERNAL) {
            long childPointer = GenerationSafePointerPair.pointer(this.childAt(cursor, keyCount, stableGeneration, unstableGeneration));
            offsetArray.add("/" + Long.toString(childPointer) + "\\");
        }
        return offsetArray.toString();
    }
}

