/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.utils;

import java.util.concurrent.ThreadLocalRandom;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2020.1.0")
public final class Strings {
    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && Strings.containsText(str);
    }

    public static String randomIdentifier(int length) {
        int leftLimit = 65;
        int rightLimit = 122;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return random.ints(leftLimit, rightLimit + 1).filter(Character::isLetter).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifierPartAt(int p, int codePoint) {
        return p == 0 && Character.isJavaIdentifierStart(codePoint) || p > 0 && Character.isJavaIdentifierPart(codePoint);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private Strings() {
    }
}

