/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.Delete;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.Limit;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NestedExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Remove;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.Skip;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.UnionPart;
import org.neo4j.cypherdsl.core.Unwind;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.ProvidesAffixes;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.internal.CaseElse;
import org.neo4j.cypherdsl.core.internal.CaseWhenThen;
import org.neo4j.cypherdsl.core.internal.ConstantParameterHolder;
import org.neo4j.cypherdsl.core.internal.Distinct;
import org.neo4j.cypherdsl.core.internal.LoadCSV;
import org.neo4j.cypherdsl.core.internal.Namespace;
import org.neo4j.cypherdsl.core.internal.ProcedureName;
import org.neo4j.cypherdsl.core.internal.ReflectiveVisitor;
import org.neo4j.cypherdsl.core.internal.RelationshipLength;
import org.neo4j.cypherdsl.core.internal.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.internal.RelationshipTypes;
import org.neo4j.cypherdsl.core.internal.StatementContext;
import org.neo4j.cypherdsl.core.internal.UsingPeriodicCommit;
import org.neo4j.cypherdsl.core.internal.YieldItems;
import org.neo4j.cypherdsl.core.renderer.RenderingVisitor;
import org.neo4j.cypherdsl.core.utils.Strings;

class DefaultVisitor
extends ReflectiveVisitor
implements RenderingVisitor {
    private static final Pattern LABEL_AND_TYPE_QUOTATION = Pattern.compile("`");
    private static final EnumSet<Operator> SKIP_SPACES = EnumSet.of(Operator.EXPONENTIATION, Operator.UNARY_MINUS, Operator.UNARY_PLUS);
    protected final StringBuilder builder = new StringBuilder();
    private final Map<Integer, AtomicReference<String>> separatorOnLevel = new ConcurrentHashMap<Integer, AtomicReference<String>>();
    private final Deque<java.util.Set<Named>> dequeOfVisitedNamed = new ArrayDeque<java.util.Set<Named>>(new HashSet());
    protected final java.util.Set<AliasedExpression> visitableToAliased = new HashSet<AliasedExpression>();
    private final Deque<AliasedExpression> currentAliasedElements = new ArrayDeque<AliasedExpression>();
    private boolean skipAliasing = false;
    private final Map<SymbolicName, String> resolvedSymbolicNames = new ConcurrentHashMap<SymbolicName, String>();
    protected final StatementContext statementContext;
    private int currentLevel = 0;
    private boolean skipNodeContent = false;
    private boolean skipRelationshipContent = false;
    private boolean inRelationshipCondition = false;
    private boolean skipSymbolicName = false;
    private final boolean alwaysEscapeNames;

    DefaultVisitor(StatementContext statementContext) {
        this(statementContext, true);
    }

    DefaultVisitor(StatementContext statementContext, boolean alwaysEscapeNames) {
        this.statementContext = statementContext;
        this.dequeOfVisitedNamed.push(new HashSet());
        this.alwaysEscapeNames = alwaysEscapeNames;
    }

    private void enableSeparator(int level, boolean on) {
        if (on) {
            this.separatorOnLevel.put(level, new AtomicReference<String>(""));
        } else {
            this.separatorOnLevel.remove(level);
        }
    }

    private Optional<AtomicReference<String>> separatorOnCurrentLevel() {
        return Optional.ofNullable(this.separatorOnLevel.get(this.currentLevel));
    }

    private String resolve(SymbolicName symbolicName) {
        return this.resolvedSymbolicNames.computeIfAbsent(symbolicName, k -> {
            String value = k.getValue();
            if (Strings.hasText(value)) {
                return this.escapeIfNecessary(symbolicName.getValue());
            }
            return String.format("%s%03d", Strings.randomIdentifier(8), this.resolvedSymbolicNames.size());
        });
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        Visitable lastAliased = this.currentAliasedElements.peek();
        if (this.skipNodeContent || this.visitableToAliased.contains(lastAliased)) {
            return false;
        }
        if (visitable instanceof ProvidesAffixes) {
            ((ProvidesAffixes)((Object)visitable)).getPrefix().ifPresent(this::doWithPrefix);
        }
        if (visitable instanceof AliasedExpression) {
            this.currentAliasedElements.push((AliasedExpression)visitable);
        }
        if (visitable instanceof MapProjection) {
            this.skipAliasing = true;
        }
        int nextLevel = ++this.currentLevel + 1;
        if (visitable instanceof TypedSubtree) {
            this.enableSeparator(nextLevel, true);
        }
        this.separatorOnCurrentLevel().ifPresent(ref -> this.builder.append(ref.getAndSet("")));
        return !this.skipNodeContent;
    }

    @Override
    protected void postLeave(Visitable visitable) {
        this.separatorOnCurrentLevel().ifPresent(ref -> ref.set(", "));
        if (visitable instanceof ProvidesAffixes) {
            ((ProvidesAffixes)((Object)visitable)).getSuffix().ifPresent(this::doWithSuffix);
        }
        if (visitable instanceof TypedSubtree) {
            this.enableSeparator(this.currentLevel + 1, false);
        }
        if (this.currentAliasedElements.peek() == visitable) {
            this.currentAliasedElements.pop();
        }
        if (visitable instanceof MapProjection) {
            this.skipAliasing = false;
        }
        if (visitable instanceof AliasedExpression) {
            AliasedExpression aliasedExpression = (AliasedExpression)visitable;
            this.visitableToAliased.add(aliasedExpression);
        }
        --this.currentLevel;
    }

    protected void doWithPrefix(String prefix) {
        this.builder.append(prefix);
    }

    protected void doWithSuffix(String suffix) {
        this.builder.append(suffix);
    }

    void enter(Match match) {
        if (match.isOptional()) {
            this.builder.append("OPTIONAL ");
        }
        this.builder.append("MATCH ");
    }

    void leave(Match match) {
        this.builder.append(" ");
    }

    void enter(Where where) {
        this.builder.append(" WHERE ");
    }

    void enter(Create create) {
        this.builder.append("CREATE ");
    }

    void leave(Create create) {
        this.builder.append(" ");
    }

    void enter(Merge merge) {
        this.builder.append("MERGE ");
    }

    void leave(Merge merge) {
        if (!merge.hasEvents()) {
            this.builder.append(" ");
        }
    }

    void enter(MergeAction onCreateOrMatchEvent) {
        switch (onCreateOrMatchEvent.getType()) {
            case ON_CREATE: {
                this.builder.append("ON CREATE");
                break;
            }
            case ON_MATCH: {
                this.builder.append("ON MATCH");
            }
        }
        this.builder.append(" ");
    }

    void enter(Condition condition) {
        this.inRelationshipCondition = condition instanceof RelationshipPatternCondition;
    }

    void leave(Condition condition) {
        this.inRelationshipCondition = false;
    }

    void enter(Distinct distinct) {
        this.builder.append("DISTINCT ");
    }

    void enter(Return returning) {
        if (!returning.isRaw()) {
            this.builder.append("RETURN ");
        }
    }

    void enter(With with) {
        this.builder.append("WITH ");
    }

    void leave(With with) {
        this.builder.append(" ");
        this.clearPreviouslyVisitedNamed(with);
    }

    void leave(Statement statement) {
        if (this.dequeOfVisitedNamed.isEmpty()) {
            return;
        }
        this.dequeOfVisitedNamed.peek().clear();
    }

    private void clearPreviouslyVisitedNamed(With with) {
        if (this.dequeOfVisitedNamed.isEmpty()) {
            return;
        }
        HashSet retain = new HashSet();
        java.util.Set<Named> visitedNamed = this.dequeOfVisitedNamed.peek();
        with.accept(segment -> {
            if (segment instanceof SymbolicName) {
                visitedNamed.stream().filter(named -> named.getRequiredSymbolicName().equals(segment)).forEach(retain::add);
            }
        });
        visitedNamed.retainAll(retain);
    }

    private boolean hasBeenVisited(Collection<Named> visited, Named needle) {
        return visited.contains(needle) || needle.getSymbolicName().isPresent() && visited.stream().map(Named::getSymbolicName).anyMatch(s -> s.equals(needle.getSymbolicName()));
    }

    void enter(Delete delete) {
        if (delete.isDetach()) {
            this.builder.append("DETACH ");
        }
        this.builder.append("DELETE ");
    }

    void leave(Delete match) {
        this.builder.append(" ");
    }

    void enter(AliasedExpression aliased) {
        if (this.visitableToAliased.contains(aliased)) {
            this.builder.append(this.escapeIfNecessary(aliased.getAlias()));
        }
    }

    void leave(AliasedExpression aliased) {
        if (!this.visitableToAliased.contains(aliased) && !this.skipAliasing) {
            this.builder.append(" AS ").append(this.escapeIfNecessary(aliased.getAlias()));
        }
    }

    void enter(NestedExpression nested) {
        this.builder.append("(");
    }

    void leave(NestedExpression nested) {
        this.builder.append(")");
    }

    void enter(Order order) {
        this.builder.append(" ORDER BY ");
    }

    void enter(Skip skip) {
        this.builder.append(" SKIP ");
    }

    void enter(Limit limit) {
        this.builder.append(" LIMIT ");
    }

    void enter(SortItem.Direction direction) {
        this.builder.append(" ").append(direction.getSymbol());
    }

    void enter(PropertyLookup propertyLookup) {
        if (propertyLookup.isDynamicLookup()) {
            this.builder.append("[");
        } else {
            this.builder.append(".");
        }
    }

    void leave(PropertyLookup propertyLookup) {
        if (propertyLookup.isDynamicLookup()) {
            this.builder.append("]");
        }
    }

    void enter(FunctionInvocation functionInvocation) {
        this.builder.append(functionInvocation.getFunctionName()).append("(");
    }

    void leave(FunctionInvocation functionInvocation) {
        this.builder.append(")");
    }

    void enter(Operation operation) {
        if (operation.needsGrouping()) {
            this.builder.append("(");
        }
    }

    void enter(Operator operator) {
        Operator.Type type = operator.getType();
        if (type == Operator.Type.LABEL) {
            return;
        }
        boolean skipSpaces = SKIP_SPACES.contains(operator);
        if (type != Operator.Type.PREFIX && !skipSpaces) {
            this.builder.append(" ");
        }
        this.builder.append(operator.getRepresentation());
        if (type != Operator.Type.POSTFIX && !skipSpaces) {
            this.builder.append(" ");
        }
    }

    void leave(Operation operation) {
        if (operation.needsGrouping()) {
            this.builder.append(")");
        }
    }

    void enter(Literal<?> expression) {
        this.builder.append(expression.asString());
    }

    void enter(Node node) {
        this.builder.append("(");
        if (!this.dequeOfVisitedNamed.isEmpty()) {
            java.util.Set<Named> visitedNamed = this.dequeOfVisitedNamed.peek();
            this.skipNodeContent = this.hasBeenVisited(visitedNamed, node);
            visitedNamed.add(node);
        }
        if (this.skipNodeContent) {
            String symbolicName = node.getSymbolicName().map(SymbolicName::getValue).orElseGet(() -> this.resolve(node.getRequiredSymbolicName()));
            this.builder.append(symbolicName);
        }
        this.skipSymbolicName = this.inRelationshipCondition;
    }

    void leave(Node node) {
        this.builder.append(")");
        this.skipNodeContent = false;
        this.skipSymbolicName = false;
    }

    void enter(NodeLabel nodeLabel) {
        this.escapeName(nodeLabel.getValue()).ifPresent(label -> this.builder.append(":").append((String)label));
    }

    void enter(Properties properties) {
        this.builder.append(" ");
    }

    void enter(SymbolicName symbolicName) {
        if (this.skipSymbolicName) {
            return;
        }
        this.builder.append(this.resolve(symbolicName));
    }

    void enter(Relationship relationship) {
        if (this.dequeOfVisitedNamed.isEmpty()) {
            return;
        }
        java.util.Set<Named> visitedNamed = this.dequeOfVisitedNamed.peek();
        this.skipRelationshipContent = this.hasBeenVisited(visitedNamed, relationship);
        visitedNamed.add(relationship);
    }

    void enter(Relationship.Details details) {
        Relationship.Direction direction = details.getDirection();
        this.builder.append(direction.getSymbolLeft());
        if (details.hasContent()) {
            this.builder.append("[");
        }
        this.skipSymbolicName = this.inRelationshipCondition && !this.skipRelationshipContent;
    }

    void enter(RelationshipTypes types) {
        if (this.skipRelationshipContent) {
            return;
        }
        this.builder.append(types.getValues().stream().map(this::escapeName).map(Optional::get).collect(Collectors.joining("|", ":", "")));
    }

    void enter(RelationshipLength length) {
        if (this.skipRelationshipContent) {
            return;
        }
        Integer minimum = length.getMinimum();
        Integer maximum = length.getMaximum();
        if (length.isUnbounded()) {
            this.builder.append("*");
            return;
        }
        if (minimum == null && maximum == null) {
            return;
        }
        this.builder.append("*");
        if (minimum != null) {
            this.builder.append(minimum);
        }
        this.builder.append("..");
        if (maximum != null) {
            this.builder.append(maximum);
        }
    }

    void leave(Relationship.Details details) {
        Relationship.Direction direction = details.getDirection();
        if (details.hasContent()) {
            this.builder.append("]");
        }
        this.builder.append(direction.getSymbolRight());
        this.skipSymbolicName = false;
    }

    void leave(Relationship relationship) {
        this.skipRelationshipContent = false;
    }

    protected final void renderParameter(Parameter<?> parameter) {
        if (this.statementContext == null) {
            throw new IllegalStateException("Parameter outside a statement context are not supported.");
        }
        this.builder.append("$").append(this.statementContext.getParameterName(parameter));
    }

    void enter(Parameter<?> parameter) {
        Object value = parameter.getValue();
        if (value instanceof ConstantParameterHolder && !this.statementContext.isRenderConstantsAsParameters()) {
            this.builder.append(((ConstantParameterHolder)value).asString());
        } else {
            this.renderParameter(parameter);
        }
    }

    void enter(MapExpression map) {
        this.builder.append("{");
    }

    void enter(KeyValueMapEntry map) {
        this.builder.append(this.escapeIfNecessary(map.getKey())).append(": ");
    }

    void leave(MapExpression map) {
        this.builder.append("}");
    }

    void enter(ListExpression list) {
        this.builder.append("[");
    }

    void leave(ListExpression list) {
        this.builder.append("]");
    }

    void enter(Unwind unwind) {
        this.builder.append("UNWIND ");
    }

    void leave(Unwind unwind) {
        this.builder.append(" AS ").append(unwind.getVariable()).append(" ");
    }

    void enter(UnionPart unionPart) {
        this.builder.append(" UNION ");
        if (unionPart.isAll()) {
            this.builder.append("ALL ");
        }
    }

    void enter(Set set) {
        this.builder.append("SET ");
    }

    void leave(Set set) {
        this.builder.append(" ");
    }

    void enter(Remove remove) {
        this.builder.append("REMOVE ");
    }

    void leave(Remove remove) {
        this.builder.append(" ");
    }

    void enter(PatternComprehension patternComprehension) {
        this.builder.append("[");
    }

    void leave(PatternComprehension patternComprehension) {
        this.builder.append("]");
    }

    void enter(ListComprehension listComprehension) {
        this.builder.append("[");
    }

    void leave(ListComprehension listComprehension) {
        this.builder.append("]");
    }

    void enter(Case genericCase) {
        this.builder.append("CASE");
    }

    void enter(Case.SimpleCase simpleCase) {
        this.builder.append("CASE ");
    }

    void enter(CaseWhenThen caseWhenExpression) {
        this.builder.append(" WHEN ");
    }

    void leave(CaseWhenThen caseWhenExpression) {
        this.builder.append(" THEN ");
    }

    void enter(CaseElse caseElseExpression) {
        this.builder.append(" ELSE ");
    }

    void leave(Case caseExpression) {
        this.builder.append(" END");
    }

    void enter(ProcedureCall procedureCall) {
        this.builder.append("CALL ");
    }

    void leave(Namespace namespace) {
        this.builder.append(".");
    }

    void leave(ProcedureName procedureName) {
        this.builder.append(procedureName.getValue());
    }

    void enter(YieldItems yieldItems) {
        this.builder.append(" YIELD ");
    }

    void leave(ProcedureCall procedureCall) {
        this.builder.append(" ");
    }

    void enter(Enum<?> statement) {
        this.builder.append(statement.name().replaceAll("_", " ")).append(" ");
    }

    void enter(Subquery subquery) {
        this.dequeOfVisitedNamed.push(new HashSet(this.dequeOfVisitedNamed.isEmpty() ? Collections.emptySet() : (Collection)this.dequeOfVisitedNamed.peek()));
        this.builder.append("CALL {");
    }

    void leave(Subquery subquery) {
        this.builder.append("} ");
        this.dequeOfVisitedNamed.pop();
    }

    void enter(ExistentialSubquery subquery) {
        this.builder.append("EXISTS {");
    }

    void leave(ExistentialSubquery subquery) {
        this.builder.replace(this.builder.length() - 1, this.builder.length(), "}");
    }

    void enter(Hint hint) {
        this.builder.append(" USING ");
    }

    void enter(LoadCSV loadCSV) {
        this.builder.append("LOAD CSV");
        if (loadCSV.isWithHeaders()) {
            this.builder.append(" WITH HEADERS");
        }
        this.builder.append(" FROM '").append(loadCSV.getUri().toString()).append("' AS ").append(loadCSV.getAlias());
        if (loadCSV.getFieldTerminator() != null) {
            this.builder.append(" FIELDTERMINATOR '").append(loadCSV.getFieldTerminator()).append("'");
        }
        this.builder.append(" ");
    }

    void enter(UsingPeriodicCommit usingPeriodicCommit) {
        this.builder.append("USING PERIODIC COMMIT ");
        if (usingPeriodicCommit.getRate() != null) {
            this.builder.append(usingPeriodicCommit.getRate()).append(" ");
        }
    }

    @Override
    public String getRenderedContent() {
        return this.builder.toString();
    }

    protected final Optional<String> escapeName(String unescapedName) {
        if (unescapedName == null) {
            return Optional.empty();
        }
        if (this.alwaysEscapeNames) {
            Matcher matcher = LABEL_AND_TYPE_QUOTATION.matcher(unescapedName);
            return Optional.of(String.format(Locale.ENGLISH, "`%s`", matcher.replaceAll("``")));
        }
        return Optional.of(this.escapeIfNecessary(unescapedName));
    }

    protected final String escapeIfNecessary(String potentiallyNonIdentifier) {
        if (potentiallyNonIdentifier == null || Strings.isIdentifier(potentiallyNonIdentifier) || potentiallyNonIdentifier.trim().isEmpty()) {
            return potentiallyNonIdentifier;
        }
        Matcher matcher = LABEL_AND_TYPE_QUOTATION.matcher(potentiallyNonIdentifier);
        return String.format(Locale.ENGLISH, "`%s`", matcher.replaceAll("``"));
    }
}

