/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.internal.RelationshipPatternCondition;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public interface Condition
extends Expression {
    @NotNull
    @Contract(pure=true)
    default public Condition and(Condition condition) {
        return CompoundCondition.create(this, Operator.AND, condition);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition or(Condition condition) {
        return CompoundCondition.create(this, Operator.OR, condition);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition xor(Condition condition) {
        return CompoundCondition.create(this, Operator.XOR, condition);
    }

    @NotNull
    @Contract(pure=true)
    default public Condition and(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.AND, RelationshipPatternCondition.of(pathPattern));
    }

    @NotNull
    @Contract(pure=true)
    default public Condition or(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.OR, RelationshipPatternCondition.of(pathPattern));
    }

    @NotNull
    @Contract(pure=true)
    default public Condition xor(RelationshipPattern pathPattern) {
        return CompoundCondition.create(this, Operator.XOR, RelationshipPatternCondition.of(pathPattern));
    }

    @NotNull
    @Contract(pure=true)
    default public Condition not() {
        return Comparison.create(Operator.NOT, this);
    }
}

