/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingGroup;

public class ConfigOptions {
    private final SettingGroup<?> settingGroup;

    public ConfigOptions(@Nonnull SettingGroup<?> settingGroup) {
        this.settingGroup = settingGroup;
    }

    @Nonnull
    public SettingGroup<?> settingGroup() {
        return this.settingGroup;
    }

    @Nonnull
    public List<ConfigValue> asConfigValues(@Nonnull Map<String, String> validConfig) {
        Map<String, Setting> settings = this.settingGroup.settings(validConfig).stream().collect(Collectors.toMap(Setting::name, s -> s));
        return this.settingGroup.values(validConfig).entrySet().stream().map(val -> {
            BaseSetting setting = (BaseSetting)settings.get(val.getKey());
            return new ConfigValue(setting.name(), setting.description(), setting.documentedDefaultValue(), Optional.ofNullable(val.getValue()), setting.valueDescription(), setting.internal(), setting.dynamic(), setting.deprecated(), setting.replacement(), setting.secret());
        }).collect(Collectors.toList());
    }
}

