/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.caseexpression.BasicWhenCondition;
import org.mybatis.dynamic.sql.select.caseexpression.ConditionBasedWhenCondition;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseWhenConditionVisitor;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.Validator;
import org.mybatis.dynamic.sql.where.render.DefaultConditionVisitor;

public class SimpleCaseWhenConditionRenderer<T>
implements SimpleCaseWhenConditionVisitor<T, FragmentAndParameters> {
    private final RenderingContext renderingContext;
    private final BindableColumn<T> column;
    private final DefaultConditionVisitor<T> conditionVisitor;

    public SimpleCaseWhenConditionRenderer(RenderingContext renderingContext, BindableColumn<T> column) {
        this.renderingContext = Objects.requireNonNull(renderingContext);
        this.column = Objects.requireNonNull(column);
        this.conditionVisitor = new DefaultConditionVisitor.Builder<T>().withColumn(column).withRenderingContext(renderingContext).build();
    }

    @Override
    public FragmentAndParameters visit(ConditionBasedWhenCondition<T> whenCondition) {
        FragmentCollector fragmentCollector = whenCondition.conditions().filter(this::shouldRender).map(this::renderCondition).collect(FragmentCollector.collect());
        Validator.assertFalse(fragmentCollector.isEmpty(), "ERROR.39");
        return fragmentCollector.toFragmentAndParameters(Collectors.joining(", "));
    }

    @Override
    public FragmentAndParameters visit(BasicWhenCondition<T> whenCondition) {
        return whenCondition.conditions().map(this::renderBasicValue).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(", "));
    }

    private boolean shouldRender(VisitableCondition<T> condition) {
        return condition.shouldRender(this.renderingContext);
    }

    private FragmentAndParameters renderCondition(VisitableCondition<T> condition) {
        return (FragmentAndParameters)condition.accept(this.conditionVisitor);
    }

    private FragmentAndParameters renderBasicValue(T value) {
        RenderedParameterInfo rpi = this.renderingContext.calculateParameterInfo(this.column);
        return FragmentAndParameters.withFragment(rpi.renderedPlaceHolder()).withParameter(rpi.parameterMapKey(), value).build();
    }
}

