/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseModel;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseWhenCondition;
import org.mybatis.dynamic.sql.select.render.SimpleCaseWhenConditionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class SimpleCaseRenderer<T> {
    private final SimpleCaseModel<T> simpleCaseModel;
    private final RenderingContext renderingContext;
    private final SimpleCaseWhenConditionRenderer<T> whenConditionRenderer;

    public SimpleCaseRenderer(SimpleCaseModel<T> simpleCaseModel, RenderingContext renderingContext) {
        this.simpleCaseModel = Objects.requireNonNull(simpleCaseModel);
        this.renderingContext = Objects.requireNonNull(renderingContext);
        this.whenConditionRenderer = new SimpleCaseWhenConditionRenderer<T>(renderingContext, simpleCaseModel.column());
    }

    public FragmentAndParameters render() {
        FragmentCollector fc = new FragmentCollector();
        fc.add(this.renderCase());
        fc.add(this.renderWhenConditions());
        this.renderElse().ifPresent(fc::add);
        fc.add(this.renderEnd());
        return fc.toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderCase() {
        return this.simpleCaseModel.column().render(this.renderingContext).mapFragment(f -> "case " + f);
    }

    private FragmentAndParameters renderWhenConditions() {
        return this.simpleCaseModel.whenConditions().map(this::renderWhenCondition).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderWhenCondition(SimpleCaseWhenCondition<T> whenCondition) {
        return Stream.of(this.renderWhen(), this.renderConditions(whenCondition), this.renderThen(whenCondition)).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderWhen() {
        return FragmentAndParameters.fromFragment("when");
    }

    private FragmentAndParameters renderConditions(SimpleCaseWhenCondition<T> whenCondition) {
        return (FragmentAndParameters)whenCondition.accept(this.whenConditionRenderer);
    }

    private FragmentAndParameters renderThen(SimpleCaseWhenCondition<T> whenCondition) {
        return whenCondition.thenValue().render(this.renderingContext).mapFragment(f -> "then " + f);
    }

    private Optional<FragmentAndParameters> renderElse() {
        return this.simpleCaseModel.elseValue().map(this::renderElse);
    }

    private FragmentAndParameters renderElse(BasicColumn elseValue) {
        return elseValue.render(this.renderingContext).mapFragment(f -> "else " + f);
    }

    private FragmentAndParameters renderEnd() {
        return FragmentAndParameters.fromFragment("end");
    }
}

