/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.caseexpression.SearchedCaseModel;
import org.mybatis.dynamic.sql.select.caseexpression.SearchedCaseWhenCondition;
import org.mybatis.dynamic.sql.select.render.SearchedCaseWhenConditionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.Messages;

public class SearchedCaseRenderer {
    private final SearchedCaseModel searchedCaseModel;
    private final RenderingContext renderingContext;

    public SearchedCaseRenderer(SearchedCaseModel searchedCaseModel, RenderingContext renderingContext) {
        this.searchedCaseModel = Objects.requireNonNull(searchedCaseModel);
        this.renderingContext = Objects.requireNonNull(renderingContext);
    }

    public FragmentAndParameters render() {
        FragmentCollector fc = new FragmentCollector();
        fc.add(this.renderCase());
        fc.add(this.renderWhenConditions());
        this.renderElse().ifPresent(fc::add);
        fc.add(this.renderEnd());
        return fc.toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderCase() {
        return FragmentAndParameters.fromFragment("case");
    }

    private FragmentAndParameters renderWhenConditions() {
        return this.searchedCaseModel.whenConditions().map(this::renderWhenCondition).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderWhenCondition(SearchedCaseWhenCondition whenCondition) {
        return Stream.of(this.renderWhen(whenCondition), this.renderThen(whenCondition)).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderWhen(SearchedCaseWhenCondition whenCondition) {
        SearchedCaseWhenConditionRenderer renderer = ((SearchedCaseWhenConditionRenderer.Builder)new SearchedCaseWhenConditionRenderer.Builder(whenCondition).withRenderingContext(this.renderingContext)).build();
        return renderer.render().orElseThrow(() -> new InvalidSqlException(Messages.getString("ERROR.39")));
    }

    private FragmentAndParameters renderThen(SearchedCaseWhenCondition whenCondition) {
        return whenCondition.thenValue().render(this.renderingContext).mapFragment(f -> "then " + f);
    }

    private Optional<FragmentAndParameters> renderElse() {
        return this.searchedCaseModel.elseValue().map(this::renderElse);
    }

    private FragmentAndParameters renderElse(BasicColumn elseValue) {
        return elseValue.render(this.renderingContext).mapFragment(f -> "else " + f);
    }

    private FragmentAndParameters renderEnd() {
        return FragmentAndParameters.fromFragment("end");
    }
}

