/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.render.FetchFirstPagingModelRenderer;
import org.mybatis.dynamic.sql.select.render.LimitAndOffsetPagingModelRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class PagingModelRenderer {
    private final PagingModel pagingModel;
    private final RenderingContext renderingContext;

    private PagingModelRenderer(Builder builder) {
        this.renderingContext = Objects.requireNonNull(builder.renderingContext);
        this.pagingModel = Objects.requireNonNull(builder.pagingModel);
    }

    public FragmentAndParameters render() {
        return this.pagingModel.limit().map(this::limitAndOffsetRender).orElseGet(this::fetchFirstRender);
    }

    private FragmentAndParameters limitAndOffsetRender(Long limit) {
        return new LimitAndOffsetPagingModelRenderer(this.renderingContext, limit, this.pagingModel).render();
    }

    private FragmentAndParameters fetchFirstRender() {
        return new FetchFirstPagingModelRenderer(this.renderingContext, this.pagingModel).render();
    }

    public static class Builder {
        private PagingModel pagingModel;
        private RenderingContext renderingContext;

        public Builder withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public Builder withPagingModel(PagingModel pagingModel) {
            this.pagingModel = pagingModel;
            return this;
        }

        public PagingModelRenderer build() {
            return new PagingModelRenderer(this);
        }
    }
}

