/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.MultiSelectModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.UnionQuery;
import org.mybatis.dynamic.sql.select.render.DefaultSelectStatementProvider;
import org.mybatis.dynamic.sql.select.render.PagingModelRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class MultiSelectRenderer {
    private final MultiSelectModel multiSelectModel;
    private final RenderingContext renderingContext;

    private MultiSelectRenderer(Builder builder) {
        this.renderingContext = RenderingContext.withRenderingStrategy(builder.renderingStrategy).withStatementConfiguration(builder.statementConfiguration).build();
        this.multiSelectModel = Objects.requireNonNull(builder.multiSelectModel);
    }

    public SelectStatementProvider render() {
        FragmentAndParameters initialSelect = this.renderSelect(this.multiSelectModel.initialSelect());
        FragmentCollector fragmentCollector = this.multiSelectModel.unionQueries().map(this::renderSelect).collect(FragmentCollector.collect(initialSelect));
        this.renderOrderBy().ifPresent(fragmentCollector::add);
        this.renderPagingModel().ifPresent(fragmentCollector::add);
        return this.toSelectStatementProvider(fragmentCollector);
    }

    private SelectStatementProvider toSelectStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultSelectStatementProvider.withSelectStatement(fragmentCollector.collectFragments(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters renderSelect(SelectModel selectModel) {
        SelectStatementProvider selectStatement = selectModel.render(this.renderingContext);
        return FragmentAndParameters.withFragment("(" + selectStatement.getSelectStatement() + ")").withParameters(selectStatement.getParameters()).build();
    }

    private FragmentAndParameters renderSelect(UnionQuery unionQuery) {
        SelectStatementProvider selectStatement = unionQuery.selectModel().render(this.renderingContext);
        return FragmentAndParameters.withFragment(unionQuery.connector() + " (" + selectStatement.getSelectStatement() + ")").withParameters(selectStatement.getParameters()).build();
    }

    private Optional<FragmentAndParameters> renderOrderBy() {
        return this.multiSelectModel.orderByModel().map(this::renderOrderBy);
    }

    private FragmentAndParameters renderOrderBy(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    private Optional<FragmentAndParameters> renderPagingModel() {
        return this.multiSelectModel.pagingModel().map(this::renderPagingModel);
    }

    private FragmentAndParameters renderPagingModel(PagingModel pagingModel) {
        return new PagingModelRenderer.Builder().withPagingModel(pagingModel).withRenderingContext(this.renderingContext).build().render();
    }

    public static class Builder {
        private RenderingStrategy renderingStrategy;
        private MultiSelectModel multiSelectModel;
        private StatementConfiguration statementConfiguration;

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withMultiSelectModel(MultiSelectModel multiSelectModel) {
            this.multiSelectModel = multiSelectModel;
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public MultiSelectRenderer build() {
            return new MultiSelectRenderer(this);
        }
    }
}

