/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.join.ColumnBasedJoinCondition;
import org.mybatis.dynamic.sql.select.join.JoinConditionVisitor;
import org.mybatis.dynamic.sql.select.join.TypedJoinCondition;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class JoinConditionRenderer<T>
implements JoinConditionVisitor<T, FragmentAndParameters> {
    private final BindableColumn<T> leftColumn;
    private final RenderingContext renderingContext;

    private JoinConditionRenderer(Builder<T> builder) {
        this.leftColumn = Objects.requireNonNull(((Builder)builder).leftColumn);
        this.renderingContext = Objects.requireNonNull(((Builder)builder).renderingContext);
    }

    @Override
    public FragmentAndParameters visit(TypedJoinCondition<T> condition) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo(this.leftColumn);
        return FragmentAndParameters.withFragment(condition.operator() + StringUtilities.spaceBefore(parameterInfo.renderedPlaceHolder())).withParameter(parameterInfo.parameterMapKey(), condition.value()).build();
    }

    @Override
    public FragmentAndParameters visit(ColumnBasedJoinCondition<T> condition) {
        return condition.rightColumn().render(this.renderingContext).mapFragment(s -> condition.operator() + StringUtilities.spaceBefore(s));
    }

    public static class Builder<T> {
        private BindableColumn<T> leftColumn;
        private RenderingContext renderingContext;

        public Builder<T> withLeftColumn(BindableColumn<T> leftColumn) {
            this.leftColumn = leftColumn;
            return this;
        }

        public Builder<T> withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public JoinConditionRenderer<T> build() {
            return new JoinConditionRenderer(this);
        }
    }
}

