/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.join;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.util.Validator;

public class JoinModel {
    private final List<JoinSpecification> joinSpecifications = new ArrayList<JoinSpecification>();

    private JoinModel(List<JoinSpecification> joinSpecifications) {
        Objects.requireNonNull(joinSpecifications);
        Validator.assertNotEmpty(joinSpecifications, "ERROR.15");
        this.joinSpecifications.addAll(joinSpecifications);
    }

    public Stream<JoinSpecification> joinSpecifications() {
        return this.joinSpecifications.stream();
    }

    public static JoinModel of(List<JoinSpecification> joinSpecifications) {
        return new JoinModel(joinSpecifications);
    }

    public boolean containsSubQueries() {
        return this.joinSpecifications.stream().map(JoinSpecification::table).anyMatch(TableExpression::isSubQuery);
    }
}

