/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.join;

import java.util.Objects;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.select.join.JoinCondition;

public class JoinCriterion<T> {
    private final String connector;
    private final BindableColumn<T> leftColumn;
    private final JoinCondition<T> joinCondition;

    private JoinCriterion(Builder<T> builder) {
        this.connector = Objects.requireNonNull(((Builder)builder).connector);
        this.leftColumn = Objects.requireNonNull(((Builder)builder).joinColumn);
        this.joinCondition = Objects.requireNonNull(((Builder)builder).joinCondition);
    }

    public String connector() {
        return this.connector;
    }

    public BindableColumn<T> leftColumn() {
        return this.leftColumn;
    }

    public JoinCondition<T> joinCondition() {
        return this.joinCondition;
    }

    public static class Builder<T> {
        private String connector;
        private BindableColumn<T> joinColumn;
        private JoinCondition<T> joinCondition;

        public Builder<T> withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder<T> withJoinColumn(BindableColumn<T> joinColumn) {
            this.joinColumn = joinColumn;
            return this;
        }

        public Builder<T> withJoinCondition(JoinCondition<T> joinCondition) {
            this.joinCondition = joinCondition;
            return this;
        }

        public JoinCriterion<T> build() {
            return new JoinCriterion(this);
        }
    }
}

