/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.caseexpression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.caseexpression.BasicWhenCondition;
import org.mybatis.dynamic.sql.select.caseexpression.ConditionBasedWhenCondition;
import org.mybatis.dynamic.sql.select.caseexpression.ElseDSL;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseModel;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseWhenCondition;
import org.mybatis.dynamic.sql.select.caseexpression.ThenDSL;

public class SimpleCaseDSL<T>
implements ElseDSL<SimpleCaseEnder> {
    private final BindableColumn<T> column;
    private final List<SimpleCaseWhenCondition<T>> whenConditions = new ArrayList<SimpleCaseWhenCondition<T>>();
    private BasicColumn elseValue;

    private SimpleCaseDSL(BindableColumn<T> column) {
        this.column = Objects.requireNonNull(column);
    }

    @SafeVarargs
    public final ConditionBasedWhenFinisher when(VisitableCondition<T> condition, VisitableCondition<T> ... subsequentConditions) {
        return this.when(condition, Arrays.asList(subsequentConditions));
    }

    public ConditionBasedWhenFinisher when(VisitableCondition<T> condition, List<VisitableCondition<T>> subsequentConditions) {
        return new ConditionBasedWhenFinisher(condition, subsequentConditions);
    }

    @SafeVarargs
    public final BasicWhenFinisher when(T condition, T ... subsequentConditions) {
        return this.when(condition, Arrays.asList(subsequentConditions));
    }

    public BasicWhenFinisher when(T condition, List<T> subsequentConditions) {
        return new BasicWhenFinisher(condition, subsequentConditions);
    }

    @Override
    public SimpleCaseEnder else_(BasicColumn column) {
        this.elseValue = column;
        return new SimpleCaseEnder();
    }

    public BasicColumn end() {
        return new SimpleCaseModel.Builder<T>().withColumn(this.column).withWhenConditions(this.whenConditions).withElseValue(this.elseValue).build();
    }

    public static <T> SimpleCaseDSL<T> simpleCase(BindableColumn<T> column) {
        return new SimpleCaseDSL<T>(column);
    }

    public class ConditionBasedWhenFinisher
    implements ThenDSL<SimpleCaseDSL<T>> {
        private final List<VisitableCondition<T>> conditions = new ArrayList();

        private ConditionBasedWhenFinisher(VisitableCondition<T> condition, List<VisitableCondition<T>> subsequentConditions) {
            this.conditions.add(condition);
            this.conditions.addAll(subsequentConditions);
        }

        @Override
        public SimpleCaseDSL<T> then(BasicColumn column) {
            SimpleCaseDSL.this.whenConditions.add(new ConditionBasedWhenCondition(this.conditions, column));
            return SimpleCaseDSL.this;
        }
    }

    public class BasicWhenFinisher
    implements ThenDSL<SimpleCaseDSL<T>> {
        private final List<T> values = new ArrayList();

        private BasicWhenFinisher(T value, List<T> subsequentValues) {
            this.values.add(value);
            this.values.addAll(subsequentValues);
        }

        @Override
        public SimpleCaseDSL<T> then(BasicColumn column) {
            SimpleCaseDSL.this.whenConditions.add(new BasicWhenCondition(this.values, column));
            return SimpleCaseDSL.this;
        }
    }

    public class SimpleCaseEnder {
        public BasicColumn end() {
            return SimpleCaseDSL.this.end();
        }
    }
}

