/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.caseexpression;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.caseexpression.SearchedCaseWhenCondition;
import org.mybatis.dynamic.sql.select.render.SearchedCaseRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.Validator;

public class SearchedCaseModel
implements BasicColumn {
    private final List<SearchedCaseWhenCondition> whenConditions;
    private final BasicColumn elseValue;
    private final String alias;

    private SearchedCaseModel(Builder builder) {
        this.whenConditions = builder.whenConditions;
        this.alias = builder.alias;
        this.elseValue = builder.elseValue;
        Validator.assertNotEmpty(this.whenConditions, "ERROR.40");
    }

    public Stream<SearchedCaseWhenCondition> whenConditions() {
        return this.whenConditions.stream();
    }

    public Optional<BasicColumn> elseValue() {
        return Optional.ofNullable(this.elseValue);
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public SearchedCaseModel as(String alias) {
        return new Builder().withWhenConditions(this.whenConditions).withElseValue(this.elseValue).withAlias(alias).build();
    }

    @Override
    public FragmentAndParameters render(RenderingContext renderingContext) {
        return new SearchedCaseRenderer(this, renderingContext).render();
    }

    public static class Builder {
        private final List<SearchedCaseWhenCondition> whenConditions = new ArrayList<SearchedCaseWhenCondition>();
        private BasicColumn elseValue;
        private String alias;

        public Builder withWhenConditions(List<SearchedCaseWhenCondition> whenConditions) {
            this.whenConditions.addAll(whenConditions);
            return this;
        }

        public Builder withElseValue(BasicColumn elseValue) {
            this.elseValue = elseValue;
            return this;
        }

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public SearchedCaseModel build() {
            return new SearchedCaseModel(this);
        }
    }
}

