/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.aggregate;

import java.util.function.Function;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.function.AbstractUniTypeFunction;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.Validator;
import org.mybatis.dynamic.sql.where.render.ColumnAndConditionRenderer;

public class Sum<T>
extends AbstractUniTypeFunction<T, Sum<T>> {
    private final Function<RenderingContext, FragmentAndParameters> renderer;

    private Sum(BindableColumn<T> column) {
        super(column);
        this.renderer = rc -> column.render((RenderingContext)rc).mapFragment(this::applyAggregate);
    }

    private Sum(BindableColumn<T> column, VisitableCondition<T> condition) {
        super(column);
        this.renderer = rc -> {
            Validator.assertTrue(condition.shouldRender((RenderingContext)rc), "ERROR.37", "sum");
            return new ColumnAndConditionRenderer.Builder().withColumn(column).withCondition(condition).withRenderingContext((RenderingContext)rc).build().render().mapFragment(this::applyAggregate);
        };
    }

    private Sum(BindableColumn<T> column, Function<RenderingContext, FragmentAndParameters> renderer) {
        super(column);
        this.renderer = renderer;
    }

    @Override
    public FragmentAndParameters render(RenderingContext renderingContext) {
        return this.renderer.apply(renderingContext);
    }

    private String applyAggregate(String s) {
        return "sum(" + s + ")";
    }

    @Override
    protected Sum<T> copy() {
        return new Sum<T>(this.column, this.renderer);
    }

    public static <T> Sum<T> of(BindableColumn<T> column) {
        return new Sum<T>(column);
    }

    public static <T> Sum<T> of(BindableColumn<T> column, VisitableCondition<T> condition) {
        return new Sum<T>(column, condition);
    }
}

