/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.AbstractSelectModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Validator;

public class SelectModel
extends AbstractSelectModel {
    private final List<QueryExpressionModel> queryExpressions;

    private SelectModel(Builder builder) {
        super(builder);
        this.queryExpressions = Objects.requireNonNull(builder.queryExpressions);
        Validator.assertNotEmpty(this.queryExpressions, "ERROR.14");
    }

    public Stream<QueryExpressionModel> queryExpressions() {
        return this.queryExpressions.stream();
    }

    @NotNull
    public SelectStatementProvider render(RenderingStrategy renderingStrategy) {
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build();
        return this.render(renderingContext);
    }

    @NotNull
    public SelectStatementProvider render(RenderingContext renderingContext) {
        return SelectRenderer.withSelectModel(this).withRenderingContext(renderingContext).build().render();
    }

    public static Builder withQueryExpressions(List<QueryExpressionModel> queryExpressions) {
        return new Builder().withQueryExpressions(queryExpressions);
    }

    public static class Builder
    extends AbstractSelectModel.AbstractBuilder<Builder> {
        private final List<QueryExpressionModel> queryExpressions = new ArrayList<QueryExpressionModel>();

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpressions.add(queryExpression);
            return this;
        }

        public Builder withQueryExpressions(List<QueryExpressionModel> queryExpressions) {
            this.queryExpressions.addAll(queryExpressions);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SelectModel build() {
            return new SelectModel(this);
        }
    }
}

