/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.MultiSelectModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.UnionQuery;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConfigurableStatement;

public class MultiSelectDSL
implements Buildable<MultiSelectModel>,
ConfigurableStatement<MultiSelectDSL> {
    private final List<UnionQuery> unionQueries = new ArrayList<UnionQuery>();
    private final SelectModel initialSelect;
    private OrderByModel orderByModel;
    private Long limit;
    private Long offset;
    private Long fetchFirstRows;
    private final StatementConfiguration statementConfiguration = new StatementConfiguration();

    public MultiSelectDSL(Buildable<SelectModel> builder) {
        this.initialSelect = builder.build();
    }

    public MultiSelectDSL union(Buildable<SelectModel> builder) {
        this.unionQueries.add(new UnionQuery("union", builder.build()));
        return this;
    }

    public MultiSelectDSL unionAll(Buildable<SelectModel> builder) {
        this.unionQueries.add(new UnionQuery("union all", builder.build()));
        return this;
    }

    public MultiSelectDSL orderBy(SortSpecification ... columns) {
        return this.orderBy(Arrays.asList(columns));
    }

    public MultiSelectDSL orderBy(Collection<? extends SortSpecification> columns) {
        this.orderByModel = OrderByModel.of(columns);
        return this;
    }

    public LimitFinisher limit(long limit) {
        this.limit = limit;
        return new LimitFinisher();
    }

    public OffsetFirstFinisher offset(long offset) {
        this.offset = offset;
        return new OffsetFirstFinisher();
    }

    public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        this.fetchFirstRows = fetchFirstRows;
        return new FetchFirstFinisher();
    }

    @Override
    @NotNull
    public MultiSelectModel build() {
        return ((MultiSelectModel.Builder)((MultiSelectModel.Builder)((MultiSelectModel.Builder)new MultiSelectModel.Builder().withInitialSelect(this.initialSelect).withUnionQueries(this.unionQueries).withOrderByModel(this.orderByModel)).withPagingModel(this.buildPagingModel().orElse(null))).withStatementConfiguration(this.statementConfiguration)).build();
    }

    private Optional<PagingModel> buildPagingModel() {
        return new PagingModel.Builder().withLimit(this.limit).withOffset(this.offset).withFetchFirstRows(this.fetchFirstRows).build();
    }

    @Override
    public MultiSelectDSL configureStatement(Consumer<StatementConfiguration> consumer) {
        consumer.accept(this.statementConfiguration);
        return this;
    }

    public class LimitFinisher
    implements Buildable<MultiSelectModel> {
        public OffsetFinisher offset(long offset) {
            MultiSelectDSL.this.offset(offset);
            return new OffsetFinisher();
        }

        @Override
        @NotNull
        public MultiSelectModel build() {
            return MultiSelectDSL.this.build();
        }
    }

    public class OffsetFirstFinisher
    implements Buildable<MultiSelectModel> {
        public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            MultiSelectDSL.this.fetchFirst(fetchFirstRows);
            return new FetchFirstFinisher();
        }

        @Override
        @NotNull
        public MultiSelectModel build() {
            return MultiSelectDSL.this.build();
        }
    }

    public class FetchFirstFinisher {
        public RowsOnlyFinisher rowsOnly() {
            return new RowsOnlyFinisher();
        }
    }

    public class RowsOnlyFinisher
    implements Buildable<MultiSelectModel> {
        @Override
        @NotNull
        public MultiSelectModel build() {
            return MultiSelectDSL.this.build();
        }
    }

    public class OffsetFinisher
    implements Buildable<MultiSelectModel> {
        @Override
        @NotNull
        public MultiSelectModel build() {
            return MultiSelectDSL.this.build();
        }
    }
}

