/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.PagingModel;

public abstract class AbstractSelectModel {
    private final OrderByModel orderByModel;
    private final PagingModel pagingModel;
    protected final StatementConfiguration statementConfiguration;

    protected AbstractSelectModel(AbstractBuilder<?> builder) {
        this.orderByModel = ((AbstractBuilder)builder).orderByModel;
        this.pagingModel = ((AbstractBuilder)builder).pagingModel;
        this.statementConfiguration = Objects.requireNonNull(((AbstractBuilder)builder).statementConfiguration);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    public Optional<PagingModel> pagingModel() {
        return Optional.ofNullable(this.pagingModel);
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private OrderByModel orderByModel;
        private PagingModel pagingModel;
        private StatementConfiguration statementConfiguration;

        public T withOrderByModel(OrderByModel orderByModel) {
            this.orderByModel = orderByModel;
            return this.getThis();
        }

        public T withPagingModel(PagingModel pagingModel) {
            this.pagingModel = pagingModel;
            return this.getThis();
        }

        public T withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

