/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class TableAliasCalculatorWithParent
implements TableAliasCalculator {
    private final TableAliasCalculator parent;
    private final TableAliasCalculator child;

    private TableAliasCalculatorWithParent(Builder builder) {
        this.parent = Objects.requireNonNull(builder.parent);
        this.child = Objects.requireNonNull(builder.child);
    }

    @Override
    public Optional<String> aliasForColumn(SqlTable table) {
        Optional<String> answer = this.child.aliasForColumn(table);
        if (answer.isPresent()) {
            return answer;
        }
        return this.parent.aliasForColumn(table);
    }

    @Override
    public Optional<String> aliasForTable(SqlTable table) {
        Optional<String> answer = this.child.aliasForTable(table);
        if (answer.isPresent()) {
            return answer;
        }
        return this.parent.aliasForTable(table);
    }

    public static class Builder {
        private TableAliasCalculator parent;
        private TableAliasCalculator child;

        public Builder withParent(TableAliasCalculator parent) {
            this.parent = parent;
            return this;
        }

        public Builder withChild(TableAliasCalculator child) {
            this.child = child;
            return this;
        }

        public TableAliasCalculatorWithParent build() {
            return new TableAliasCalculatorWithParent(this);
        }
    }
}

