/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Optional;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueAndParameters;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.InsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.PropertyWhenPresentMapping;
import org.mybatis.dynamic.sql.util.RowMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class ValuePhraseVisitor
extends InsertMappingVisitor<Optional<FieldAndValueAndParameters>> {
    protected final RenderingStrategy renderingStrategy;

    public ValuePhraseVisitor(RenderingStrategy renderingStrategy) {
        this.renderingStrategy = renderingStrategy;
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(NullMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase("null").buildOptional();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(ConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(mapping.constant()).buildOptional();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(StringConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(StringUtilities.formatConstantForSQL(mapping.constant())).buildOptional();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(PropertyMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(this.calculateJdbcPlaceholder(mapping.column(), mapping.property())).buildOptional();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(PropertyWhenPresentMapping mapping) {
        if (mapping.shouldRender()) {
            return this.visit((PropertyMapping)mapping);
        }
        return Optional.empty();
    }

    @Override
    public Optional<FieldAndValueAndParameters> visit(RowMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(this.calculateJdbcPlaceholder(mapping.column())).buildOptional();
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getRecordBasedInsertBinding(column, "row");
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column, String parameterName) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getRecordBasedInsertBinding(column, "row", parameterName);
    }
}

