/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueAndParameters;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.MultiRowInsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.RowMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class MultiRowValuePhraseVisitor
extends MultiRowInsertMappingVisitor<FieldAndValueAndParameters> {
    protected final RenderingStrategy renderingStrategy;
    protected final String prefix;

    protected MultiRowValuePhraseVisitor(RenderingStrategy renderingStrategy, String prefix) {
        this.renderingStrategy = Objects.requireNonNull(renderingStrategy);
        this.prefix = Objects.requireNonNull(prefix);
    }

    @Override
    public FieldAndValueAndParameters visit(NullMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase("null").build();
    }

    @Override
    public FieldAndValueAndParameters visit(ConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(mapping.constant()).build();
    }

    @Override
    public FieldAndValueAndParameters visit(StringConstantMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(StringUtilities.formatConstantForSQL(mapping.constant())).build();
    }

    @Override
    public FieldAndValueAndParameters visit(PropertyMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(this.calculateJdbcPlaceholder(mapping.column(), mapping.property())).build();
    }

    @Override
    public FieldAndValueAndParameters visit(RowMapping mapping) {
        return FieldAndValueAndParameters.withFieldName(mapping.columnName()).withValuePhrase(this.calculateJdbcPlaceholder(mapping.column())).build();
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getRecordBasedInsertBinding(column, this.prefix);
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column, String parameterName) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getRecordBasedInsertBinding(column, this.prefix, parameterName);
    }
}

