/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.insert.InsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.InsertRenderingUtilities;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.ValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.Validator;

public class InsertRenderer<T> {
    private final InsertModel<T> model;
    private final ValuePhraseVisitor visitor;

    private InsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.visitor = new ValuePhraseVisitor(((Builder)builder).renderingStrategy);
    }

    public InsertStatementProvider<T> render() {
        FieldAndValueCollector collector = this.model.columnMappings().map(m -> m.accept(this.visitor)).filter(Optional::isPresent).map(Optional::get).collect(FieldAndValueCollector.collect());
        Validator.assertFalse(collector.isEmpty(), "ERROR.10");
        String insertStatement = InsertRenderingUtilities.calculateInsertStatement(this.model.table(), collector);
        return DefaultInsertStatementProvider.withRow(this.model.row()).withInsertStatement(insertStatement).build();
    }

    public static <T> Builder<T> withInsertModel(InsertModel<T> model) {
        return new Builder<T>().withInsertModel(model);
    }

    public static class Builder<T> {
        private InsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withInsertModel(InsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public InsertRenderer<T> build() {
            return new InsertRenderer(this);
        }
    }
}

