/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.insert.GeneralInsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultGeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertValuePhraseVisitor;
import org.mybatis.dynamic.sql.insert.render.InsertRenderingUtilities;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.Validator;

public class GeneralInsertRenderer {
    private final GeneralInsertModel model;
    private final GeneralInsertValuePhraseVisitor visitor;

    private GeneralInsertRenderer(Builder builder) {
        this.model = Objects.requireNonNull(builder.model);
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(builder.renderingStrategy).withStatementConfiguration(builder.statementConfiguration).build();
        this.visitor = new GeneralInsertValuePhraseVisitor(renderingContext);
    }

    public GeneralInsertStatementProvider render() {
        FieldAndValueCollector collector = this.model.columnMappings().map(m -> m.accept(this.visitor)).filter(Optional::isPresent).map(Optional::get).collect(FieldAndValueCollector.collect());
        Validator.assertFalse(collector.isEmpty(), "ERROR.9");
        String insertStatement = InsertRenderingUtilities.calculateInsertStatement(this.model.table(), collector);
        return DefaultGeneralInsertStatementProvider.withInsertStatement(insertStatement).withParameters(collector.parameters()).build();
    }

    public static Builder withInsertModel(GeneralInsertModel model) {
        return new Builder().withInsertModel(model);
    }

    public static class Builder {
        private GeneralInsertModel model;
        private RenderingStrategy renderingStrategy;
        private StatementConfiguration statementConfiguration;

        public Builder withInsertModel(GeneralInsertModel model) {
            this.model = model;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public GeneralInsertRenderer build() {
            return new GeneralInsertRenderer(this);
        }
    }
}

