/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.insert.render.InsertRenderer;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Validator;

public class InsertModel<T> {
    private final SqlTable table;
    private final T row;
    private final List<AbstractColumnMapping> columnMappings;

    private InsertModel(Builder<T> builder) {
        this.table = Objects.requireNonNull(((Builder)builder).table);
        this.row = Objects.requireNonNull(((Builder)builder).row);
        this.columnMappings = Objects.requireNonNull(((Builder)builder).columnMappings);
        Validator.assertNotEmpty(this.columnMappings, "ERROR.7");
    }

    public Stream<AbstractColumnMapping> columnMappings() {
        return this.columnMappings.stream();
    }

    public T row() {
        return this.row;
    }

    public SqlTable table() {
        return this.table;
    }

    @NotNull
    public InsertStatementProvider<T> render(RenderingStrategy renderingStrategy) {
        return InsertRenderer.withInsertModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static <T> Builder<T> withRow(T row) {
        return new Builder<T>().withRow(row);
    }

    public static class Builder<T> {
        private SqlTable table;
        private T row;
        private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

        public Builder<T> withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder<T> withRow(T row) {
            this.row = row;
            return this;
        }

        public Builder<T> withColumnMappings(List<? extends AbstractColumnMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        public InsertModel<T> build() {
            return new InsertModel(this);
        }
    }
}

