/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertRenderer;
import org.mybatis.dynamic.sql.insert.render.GeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Validator;

public class GeneralInsertModel {
    private final SqlTable table;
    private final List<AbstractColumnMapping> insertMappings;
    private final StatementConfiguration statementConfiguration;

    private GeneralInsertModel(Builder builder) {
        this.table = Objects.requireNonNull(builder.table);
        Validator.assertNotEmpty(builder.insertMappings, "ERROR.6");
        this.insertMappings = builder.insertMappings;
        this.statementConfiguration = Objects.requireNonNull(builder.statementConfiguration);
    }

    public Stream<AbstractColumnMapping> columnMappings() {
        return this.insertMappings.stream();
    }

    public SqlTable table() {
        return this.table;
    }

    @NotNull
    public GeneralInsertStatementProvider render(RenderingStrategy renderingStrategy) {
        return GeneralInsertRenderer.withInsertModel(this).withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build().render();
    }

    public static class Builder {
        private SqlTable table;
        private final List<AbstractColumnMapping> insertMappings = new ArrayList<AbstractColumnMapping>();
        private StatementConfiguration statementConfiguration;

        public Builder withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder withInsertMappings(List<? extends AbstractColumnMapping> insertMappings) {
            this.insertMappings.addAll(insertMappings);
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public GeneralInsertModel build() {
            return new GeneralInsertModel(this);
        }
    }
}

