/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.common;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.common.AbstractBooleanExpressionModel;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.render.CriterionRenderer;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;

public abstract class AbstractBooleanExpressionRenderer {
    protected final AbstractBooleanExpressionModel model;
    private final String prefix;
    private final CriterionRenderer criterionRenderer;
    protected final RenderingContext renderingContext;

    protected AbstractBooleanExpressionRenderer(String prefix, AbstractBuilder<?> builder) {
        this.model = Objects.requireNonNull(((AbstractBuilder)builder).model);
        this.prefix = Objects.requireNonNull(prefix);
        this.renderingContext = Objects.requireNonNull(((AbstractBuilder)builder).renderingContext);
        this.criterionRenderer = new CriterionRenderer(this.renderingContext);
    }

    public Optional<FragmentAndParameters> render() {
        return this.model.initialCriterion().map(this::renderWithInitialCriterion).orElseGet(this::renderWithoutInitialCriterion).map(RenderedCriterion::fragmentAndParameters);
    }

    private Optional<RenderedCriterion> renderWithInitialCriterion(SqlCriterion initialCriterion) {
        return this.criterionRenderer.render(initialCriterion, this.model.subCriteria(), this::calculateClause);
    }

    private Optional<RenderedCriterion> renderWithoutInitialCriterion() {
        return this.criterionRenderer.render(this.model.subCriteria(), this::calculateClause);
    }

    private String calculateClause(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.collectFragments(Collectors.joining(" ", StringUtilities.spaceAfter(this.prefix), ""));
        }
        return collector.firstFragment().map(this::stripEnclosingParenthesesIfPresent).map(this::addPrefix).orElse("");
    }

    private String stripEnclosingParenthesesIfPresent(String fragment) {
        if (fragment.startsWith("(") && fragment.endsWith(")")) {
            return fragment.substring(1, fragment.length() - 1);
        }
        return fragment;
    }

    private String addPrefix(String fragment) {
        return StringUtilities.spaceAfter(this.prefix) + fragment;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private final AbstractBooleanExpressionModel model;
        private RenderingContext renderingContext;

        protected AbstractBuilder(AbstractBooleanExpressionModel model) {
            this.model = model;
        }

        public B withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this.getThis();
        }

        protected abstract B getThis();
    }
}

