/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.SqlCriterion;

public class AndOrCriteriaGroup {
    private final String connector;
    private final SqlCriterion initialCriterion;
    private final List<AndOrCriteriaGroup> subCriteria;

    private AndOrCriteriaGroup(Builder builder) {
        this.connector = Objects.requireNonNull(builder.connector);
        this.initialCriterion = builder.initialCriterion;
        this.subCriteria = builder.subCriteria;
    }

    public String connector() {
        return this.connector;
    }

    public Optional<SqlCriterion> initialCriterion() {
        return Optional.ofNullable(this.initialCriterion);
    }

    public List<AndOrCriteriaGroup> subCriteria() {
        return Collections.unmodifiableList(this.subCriteria);
    }

    public static class Builder {
        private String connector;
        private SqlCriterion initialCriterion;
        private final List<AndOrCriteriaGroup> subCriteria = new ArrayList<AndOrCriteriaGroup>();

        public Builder withConnector(String connector) {
            this.connector = connector;
            return this;
        }

        public Builder withInitialCriterion(SqlCriterion initialCriterion) {
            this.initialCriterion = initialCriterion;
            return this;
        }

        public Builder withSubCriteria(List<AndOrCriteriaGroup> subCriteria) {
            this.subCriteria.addAll(subCriteria);
            return this;
        }

        public AndOrCriteriaGroup build() {
            return new AndOrCriteriaGroup(this);
        }
    }
}

