/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.CriterionRenderer;
import org.mybatis.dynamic.sql.where.render.RenderedCriterion;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;

public class WhereRenderer {
    private WhereModel whereModel;
    private AtomicInteger sequence;
    private RenderingStrategy renderingStrategy;
    private TableAliasCalculator tableAliasCalculator;
    private String parameterName;

    private WhereRenderer(Builder builder) {
        this.whereModel = Objects.requireNonNull(builder.whereModel);
        this.sequence = Objects.requireNonNull(builder.sequence);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.tableAliasCalculator = Objects.requireNonNull(builder.tableAliasCalculator);
        this.parameterName = builder.parameterName;
    }

    public Optional<WhereClauseProvider> render() {
        List renderedCriteria = this.whereModel.mapCriteria(this::render).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (renderedCriteria.isEmpty()) {
            return Optional.empty();
        }
        FragmentAndParameters initialCriterion = ((RenderedCriterion)renderedCriteria.get(0)).renderWithoutInitialConnector();
        FragmentCollector fc = renderedCriteria.stream().skip(1L).map(RenderedCriterion::renderWithInitialConnector).collect(FragmentCollector.collect(initialCriterion));
        WhereClauseProvider wcp = WhereClauseProvider.withWhereClause(this.calculateWhereClause(fc)).withParameters(fc.parameters()).build();
        return Optional.of(wcp);
    }

    private Optional<RenderedCriterion> render(SqlCriterion<?> criterion) {
        return CriterionRenderer.withCriterion(criterion).withSequence(this.sequence).withRenderingStrategy(this.renderingStrategy).withTableAliasCalculator(this.tableAliasCalculator).withParameterName(this.parameterName).build().render();
    }

    private String calculateWhereClause(FragmentCollector collector) {
        return collector.fragments().collect(Collectors.joining(" ", "where ", ""));
    }

    public static Builder withWhereModel(WhereModel whereModel) {
        return new Builder().withWhereModel(whereModel);
    }

    public static class Builder {
        private WhereModel whereModel;
        private RenderingStrategy renderingStrategy;
        private TableAliasCalculator tableAliasCalculator;
        private AtomicInteger sequence;
        private String parameterName;

        public Builder withWhereModel(WhereModel whereModel) {
            this.whereModel = whereModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder withParameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public WhereRenderer build() {
            return new WhereRenderer(this);
        }
    }
}

