/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class FetchFirstPagingModelRenderer {
    private RenderingStrategy renderingStrategy;
    private PagingModel pagingModel;
    private AtomicInteger sequence;

    public FetchFirstPagingModelRenderer(RenderingStrategy renderingStrategy, PagingModel pagingModel, AtomicInteger sequence) {
        this.renderingStrategy = renderingStrategy;
        this.pagingModel = pagingModel;
        this.sequence = sequence;
    }

    public Optional<FragmentAndParameters> render() {
        return this.pagingModel.offset().map(this::renderWithOffset).orElseGet(this::renderFetchFirstRowsOnly);
    }

    private Optional<FragmentAndParameters> renderWithOffset(Long offset) {
        return this.pagingModel.fetchFirstRows().map(ffr -> this.renderOffsetAndFetchFirstRows(offset, (Long)ffr)).orElseGet(() -> this.renderOffsetOnly(offset));
    }

    private Optional<FragmentAndParameters> renderFetchFirstRowsOnly() {
        return this.pagingModel.fetchFirstRows().flatMap(this::renderFetchFirstRowsOnly);
    }

    private Optional<FragmentAndParameters> renderFetchFirstRowsOnly(Long fetchFirstRows) {
        String mapKey = RenderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("fetch first " + this.renderPlaceholder(mapKey) + " rows only").withParameter(mapKey, fetchFirstRows).buildOptional();
    }

    private Optional<FragmentAndParameters> renderOffsetOnly(Long offset) {
        String mapKey = RenderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(mapKey) + " rows").withParameter(mapKey, offset).buildOptional();
    }

    private Optional<FragmentAndParameters> renderOffsetAndFetchFirstRows(Long offset, Long fetchFirstRows) {
        String mapKey1 = RenderingStrategy.formatParameterMapKey(this.sequence);
        String mapKey2 = RenderingStrategy.formatParameterMapKey(this.sequence);
        return FragmentAndParameters.withFragment("offset " + this.renderPlaceholder(mapKey1) + " rows fetch first " + this.renderPlaceholder(mapKey2) + " rows only").withParameter(mapKey1, offset).withParameter(mapKey2, fetchFirstRows).buildOptional();
    }

    private String renderPlaceholder(String parameterName) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", parameterName);
    }
}

