/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.select.MyBatis3SelectModelAdapter;
import org.mybatis.dynamic.sql.select.OrderByModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Buildable;

public class SelectDSL<R>
implements Buildable<R> {
    private Function<SelectModel, R> adapterFunction;
    private List<QueryExpressionDSL<R>> queryExpressions = new ArrayList<QueryExpressionDSL<R>>();
    private OrderByModel orderByModel;
    private Long limit;
    private Long offset;
    private Long fetchFirstRows;

    private SelectDSL(Function<SelectModel, R> adapterFunction) {
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(BasicColumn ... selectList) {
        return SelectDSL.select(Arrays.asList(selectList));
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(Collection<BasicColumn> selectList) {
        return SelectDSL.select(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        return SelectDSL.select(adapterFunction, Arrays.asList(selectList));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, Collection<BasicColumn> selectList) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList).withSelectDSL(new SelectDSL<R>(adapterFunction)).build();
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(Arrays.asList(selectList));
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(Collection<BasicColumn> selectList) {
        return SelectDSL.selectDistinct(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(adapterFunction, Arrays.asList(selectList));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, Collection<BasicColumn> selectList) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList).withSelectDSL(new SelectDSL<R>(adapterFunction)).isDistinct().build();
    }

    @Deprecated
    public static <T> QueryExpressionDSL.FromGatherer<MyBatis3SelectModelAdapter<T>> selectWithMapper(Function<SelectStatementProvider, T> mapperMethod, BasicColumn ... selectList) {
        return SelectDSL.select((SelectModel selectModel) -> MyBatis3SelectModelAdapter.of(selectModel, mapperMethod), selectList);
    }

    @Deprecated
    public static <T> QueryExpressionDSL.FromGatherer<MyBatis3SelectModelAdapter<T>> selectDistinctWithMapper(Function<SelectStatementProvider, T> mapperMethod, BasicColumn ... selectList) {
        return SelectDSL.selectDistinct((SelectModel selectModel) -> MyBatis3SelectModelAdapter.of(selectModel, mapperMethod), selectList);
    }

    QueryExpressionDSL<R> newQueryExpression(QueryExpressionDSL.FromGatherer<R> fromGatherer) {
        QueryExpressionDSL<R> queryExpression = new QueryExpressionDSL<R>(fromGatherer);
        this.queryExpressions.add(queryExpression);
        return queryExpression;
    }

    QueryExpressionDSL<R> newQueryExpression(QueryExpressionDSL.FromGatherer<R> fromGatherer, String tableAlias) {
        QueryExpressionDSL<R> queryExpression = new QueryExpressionDSL<R>(fromGatherer, tableAlias);
        this.queryExpressions.add(queryExpression);
        return queryExpression;
    }

    void orderBy(SortSpecification ... columns) {
        this.orderByModel = OrderByModel.of(columns);
    }

    public LimitFinisher limit(long limit) {
        this.limit = limit;
        return new LimitFinisher();
    }

    public OffsetFirstFinisher offset(long offset) {
        this.offset = offset;
        return new OffsetFirstFinisher();
    }

    public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        this.fetchFirstRows = fetchFirstRows;
        return new FetchFirstFinisher();
    }

    @Override
    public R build() {
        SelectModel selectModel = SelectModel.withQueryExpressions(this.buildModels()).withOrderByModel(this.orderByModel).withPagingModel(this.buildPagingModel()).build();
        return this.adapterFunction.apply(selectModel);
    }

    private List<QueryExpressionModel> buildModels() {
        return this.queryExpressions.stream().map(QueryExpressionDSL::buildModel).collect(Collectors.toList());
    }

    private PagingModel buildPagingModel() {
        return new PagingModel.Builder().withLimit(this.limit).withOffset(this.offset).withFetchFirstRows(this.fetchFirstRows).build();
    }

    public class RowsOnlyFinisher
    implements Buildable<R> {
        @Override
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class FetchFirstFinisher {
        public RowsOnlyFinisher rowsOnly() {
            return new RowsOnlyFinisher();
        }
    }

    public class OffsetFirstFinisher
    implements Buildable<R> {
        public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            SelectDSL.this.fetchFirstRows = fetchFirstRows;
            return new FetchFirstFinisher();
        }

        @Override
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class OffsetFinisher
    implements Buildable<R> {
        @Override
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class LimitFinisher
    implements Buildable<R> {
        public OffsetFinisher offset(long offset) {
            SelectDSL.this.offset = offset;
            return new OffsetFinisher();
        }

        @Override
        public R build() {
            return SelectDSL.this.build();
        }
    }
}

