/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.function.Function;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.InsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public class ValuePhraseVisitor
implements InsertMappingVisitor<FieldAndValue> {
    protected RenderingStrategy renderingStrategy;

    public ValuePhraseVisitor(RenderingStrategy renderingStrategy) {
        this.renderingStrategy = renderingStrategy;
    }

    @Override
    public FieldAndValue visit(NullMapping mapping) {
        return FieldAndValue.withFieldName(mapping.mapColumn(SqlColumn::name)).withValuePhrase("null").build();
    }

    @Override
    public FieldAndValue visit(ConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.mapColumn(SqlColumn::name)).withValuePhrase(mapping.constant()).build();
    }

    @Override
    public FieldAndValue visit(StringConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.mapColumn(SqlColumn::name)).withValuePhrase("'" + mapping.constant() + "'").build();
    }

    @Override
    public FieldAndValue visit(PropertyMapping mapping) {
        return FieldAndValue.withFieldName(mapping.mapColumn(SqlColumn::name)).withValuePhrase(mapping.mapColumn(this.toJdbcPlaceholder(mapping.property()))).build();
    }

    private Function<SqlColumn<?>, String> toJdbcPlaceholder(String parameterName) {
        return column -> this.renderingStrategy.getFormattedJdbcPlaceholder((BindableColumn<?>)column, "record", parameterName);
    }
}

