/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.InsertColumnListModel;
import org.mybatis.dynamic.sql.insert.InsertSelectModel;
import org.mybatis.dynamic.sql.insert.render.DefaultInsertSelectStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertSelectStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class InsertSelectRenderer {
    private InsertSelectModel model;
    private RenderingStrategy renderingStrategy;

    private InsertSelectRenderer(Builder builder) {
        this.model = Objects.requireNonNull(builder.model);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
    }

    public InsertSelectStatementProvider render() {
        SelectStatementProvider selectStatement = this.model.selectModel().render(this.renderingStrategy);
        return DefaultInsertSelectStatementProvider.withInsertStatement(this.calculateInsertStatement(selectStatement)).withParameters(selectStatement.getParameters()).build();
    }

    private String calculateInsertStatement(SelectStatementProvider selectStatement) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(this.calculateColumnsPhrase()) + StringUtilities.spaceBefore(selectStatement.getSelectStatement());
    }

    private Optional<String> calculateColumnsPhrase() {
        return this.model.columnList().map(this::calculateColumnsPhrase);
    }

    private String calculateColumnsPhrase(InsertColumnListModel columnList) {
        return columnList.mapColumns(SqlColumn::name).collect(Collectors.joining(", ", "(", ")"));
    }

    public static Builder withInsertSelectModel(InsertSelectModel model) {
        return new Builder().withInsertSelectModel(model);
    }

    public static class Builder {
        private InsertSelectModel model;
        private RenderingStrategy renderingStrategy;

        public Builder withInsertSelectModel(InsertSelectModel model) {
            this.model = model;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public InsertSelectRenderer build() {
            return new InsertSelectRenderer(this);
        }
    }
}

