/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.delete.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DefaultDeleteStatementProvider;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class DeleteRenderer {
    private DeleteModel deleteModel;
    private RenderingStrategy renderingStrategy;

    private DeleteRenderer(Builder builder) {
        this.deleteModel = Objects.requireNonNull(builder.deleteModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
    }

    public DeleteStatementProvider render() {
        return this.deleteModel.whereModel().flatMap(this::renderWhereClause).map(this::renderWithWhereClause).orElseGet(this::renderWithoutWhereClause);
    }

    private DeleteStatementProvider renderWithWhereClause(WhereClauseProvider whereClauseProvider) {
        return DefaultDeleteStatementProvider.withDeleteStatement(this.calculateDeleteStatement(whereClauseProvider)).withParameters(whereClauseProvider.getParameters()).build();
    }

    private String calculateDeleteStatement(WhereClauseProvider whereClause) {
        return this.calculateDeleteStatement() + StringUtilities.spaceBefore(whereClause.getWhereClause());
    }

    private String calculateDeleteStatement() {
        return "delete from" + StringUtilities.spaceBefore(this.deleteModel.table().tableNameAtRuntime());
    }

    private DeleteStatementProvider renderWithoutWhereClause() {
        return DefaultDeleteStatementProvider.withDeleteStatement(this.calculateDeleteStatement()).build();
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withSequence(new AtomicInteger(1)).withTableAliasCalculator(TableAliasCalculator.empty()).build().render();
    }

    public static Builder withDeleteModel(DeleteModel deleteModel) {
        return new Builder().withDeleteModel(deleteModel);
    }

    public static class Builder {
        private DeleteModel deleteModel;
        private RenderingStrategy renderingStrategy;

        public Builder withDeleteModel(DeleteModel deleteModel) {
            this.deleteModel = deleteModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public DeleteRenderer build() {
            return new DeleteRenderer(this);
        }
    }
}

