/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.spec.swagger;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import leap.lang.Arrays2;
import leap.lang.Collections2;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.lang.io.IO;
import leap.lang.json.JSON;
import leap.lang.json.JsonObject;
import leap.lang.meta.MCollectionType;
import leap.lang.meta.MComplexTypeRef;
import leap.lang.meta.MDictionaryType;
import leap.lang.meta.MObjectType;
import leap.lang.meta.MProperty;
import leap.lang.meta.MPropertyBuilder;
import leap.lang.meta.MSimpleType;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.lang.yaml.YAML;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.model.MApiContactBuilder;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiParameterBaseBuilder;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiPathBuilder;
import leap.web.api.meta.model.MApiPropertyBuilder;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.meta.model.MApiSecurityDef;
import leap.web.api.meta.model.MApiSecurityReq;
import leap.web.api.meta.model.MApiTag;
import leap.web.api.meta.model.MApiValidationBuilder;
import leap.web.api.meta.model.MOAuth2ApiSecurityDef;
import leap.web.api.spec.ApiSpecReader;
import leap.web.api.spec.InvalidSpecException;
import leap.web.api.spec.UnsupportedSpecException;
import leap.web.api.spec.swagger.SwaggerExtension;

public class SwaggerSpecReader
implements ApiSpecReader {
    private final List<String> HTTP_METHODS_LOWER_CASE = Arrays.asList("get", "put", "post", "delete", "options", "head", "patch");
    protected boolean validate = true;

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    @Override
    public ApiMetadataBuilder read(Reader reader) throws IOException {
        String content = IO.readString((Reader)reader).trim();
        Map swagger = content.startsWith("{") ? (Map)JSON.decode((String)content) : (Map)YAML.decode((String)content);
        ApiMetadataBuilder m = new ApiMetadataBuilder();
        this.readSwagger(swagger, m);
        return m;
    }

    public void readSwagger(Map<String, Object> map, ApiMetadataBuilder m) {
        JsonObject swagger = JsonObject.of(map);
        String swaggerVersion = swagger.getString("swagger");
        if (!"2.0".equals(swaggerVersion)) {
            throw new UnsupportedSpecException("Unsupported swagger version : " + swaggerVersion);
        }
        this.readBase(map, m);
        this.readPaths(swagger.getMap("paths"), m);
        this.readSecurityDefinitions(swagger.getMap("securityDefinitions"), m);
        this.readDefinitions(swagger.getMap("definitions"), m);
        this.readResponses(swagger.getMap("responses"), m);
        this.readTags(swagger.getList("tags"), m);
    }

    public void readBase(Map<String, Object> map, ApiMetadataBuilder m) {
        JsonObject info;
        List consumes;
        List produces;
        JsonObject swagger = JsonObject.of(map);
        m.setHost(swagger.getString("host"));
        m.setBasePath(swagger.getString("basePath"));
        List schemes = swagger.getList("schemes");
        if (null != schemes) {
            schemes.forEach(s -> m.addProtocol((String)s));
        }
        if (null != (produces = swagger.getList("produces"))) {
            produces.forEach(m::addProduce);
        }
        if (null != (consumes = swagger.getList("consumes"))) {
            consumes.forEach(m::addConsume);
        }
        if (null != (info = swagger.getObject("info"))) {
            m.setVersion(info.getString("version"));
            m.setTitle(info.getString("title"));
            m.setName(m.getTitle());
            m.setSummary(info.getString("summary"));
            m.setDescription(info.getString("description"));
            m.setTermsOfService(info.getString("termsOfService"));
            JsonObject contact = info.getObject("contact");
            if (null != contact) {
                MApiContactBuilder c = new MApiContactBuilder();
                c.setName(contact.getString("name"));
                c.setEmail(contact.getString("email"));
                c.setUrl(contact.getString("url"));
                m.setContact(c);
            }
        }
    }

    public void readPaths(Map<String, Object> paths, ApiMetadataBuilder m) {
        if (null == paths) {
            return;
        }
        paths.forEach((pathTemplate, path) -> m.addPath(this.readPath((String)pathTemplate, (Map)path)));
    }

    public MApiPathBuilder readPath(String pathTemplate, Map<String, Object> map) {
        return this.readPath(null, pathTemplate, map);
    }

    public MApiOperationBuilder readOperation(String method, Map<String, Object> map) {
        return this.readOperation(null, null, method, map);
    }

    protected MApiPathBuilder readPath(ApiMetadataBuilder m, String pathTemplate, Map<String, Object> map) {
        MApiPathBuilder mp = new MApiPathBuilder();
        mp.setPathTemplate(pathTemplate);
        map.forEach((method, operation) -> {
            if (this.HTTP_METHODS_LOWER_CASE.contains(method) && null != operation) {
                mp.addOperation(this.readOperation((String)method, (Map)operation));
            }
        });
        return mp;
    }

    protected MApiOperationBuilder readOperation(ApiMetadataBuilder m, MApiPathBuilder p, String method, Map<String, Object> map) {
        List consumes;
        MApiOperationBuilder mo = new MApiOperationBuilder();
        JsonObject o = JsonObject.of(map);
        mo.setMethod(HTTP.Method.valueOf((String)method.toUpperCase()));
        mo.setCorsEnabled((Boolean)o.get("x-cors", Boolean.class));
        List tags = o.getList("tags");
        if (null != tags) {
            tags.forEach(mo::addTag);
        }
        mo.setSummary(o.getString("summary"));
        mo.setDescription(o.getString("description"));
        mo.setDeprecated((Boolean)o.get("deprecated", Boolean.class, (Object)false));
        List produces = o.getList("produces");
        if (null != produces) {
            produces.forEach(mo::addProduce);
        }
        if (null != (consumes = o.getList("consumes"))) {
            consumes.forEach(mo::addConsume);
        }
        List<MApiParameterBuilder> params = this.readParameters(o.getList("parameters"));
        params.forEach(mo::addParameter);
        List<MApiResponseBuilder> responses = this.readResponses(o.getMap("responses"));
        responses.forEach(mo::addResponse);
        List security = o.getList("security");
        if (null != security) {
            security.forEach(sc -> {
                block0: {
                    Iterator iterator = sc.entrySet().iterator();
                    if (!iterator.hasNext()) break block0;
                    Map.Entry entry = iterator.next();
                    MApiSecurityReq sec = new MApiSecurityReq((String)entry.getKey());
                    sec.addScopes(Collections2.toStringArray((Collection)((Collection)entry.getValue())));
                    mo.getSecurity().put(sec.getName(), sec);
                }
            });
        } else {
            mo.setAllowAnonymous(true);
        }
        String id = o.getString("operationId");
        if (!Strings.isEmpty((String)id)) {
            mo.setId(id);
            mo.setName(id);
        } else {
            mo.setName(mo.getMethod().name().toLowerCase());
        }
        return mo;
    }

    public List<MApiParameterBuilder> readParameters(List<Map<String, Object>> list) {
        ArrayList<MApiParameterBuilder> params = new ArrayList<MApiParameterBuilder>();
        if (null != list) {
            list.forEach(p -> params.add(this.readParameter((Map<String, Object>)p)));
        }
        return params;
    }

    public MApiParameterBuilder readParameter(Map<String, Object> map) {
        MApiParameterBuilder mp = new MApiParameterBuilder();
        JsonObject p = JsonObject.of(map);
        this.readParameterBase(null, p, mp);
        mp.setLocation(this.readParameterIn(mp.getName(), p.getString("in")));
        return mp;
    }

    public List<MApiResponseBuilder> readResponses(Map<String, Object> map) {
        ArrayList<MApiResponseBuilder> responses = new ArrayList<MApiResponseBuilder>();
        if (null != map) {
            for (String key : map.keySet()) {
                String name = key.toString();
                Map resp = (Map)map.get(key);
                responses.add(this.readResponse(name, resp));
            }
        }
        return responses;
    }

    public MApiResponseBuilder readResponse(String name, Map<String, Object> map) {
        MApiResponseBuilder mr = new MApiResponseBuilder();
        JsonObject resp = JsonObject.of(map);
        mr.setName(name);
        mr.setSummary(resp.getString("summary"));
        mr.setDescription(resp.getString("description"));
        try {
            mr.setStatus(Integer.parseInt(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JsonObject schema = resp.getObject("schema");
        if (null != schema) {
            mr.setType(this.readType(schema));
        }
        return mr;
    }

    public void readSecurityDefinitions(Map<String, Object> definitions, ApiMetadataBuilder m) {
        if (null == definitions) {
            return;
        }
        definitions.forEach((name, def) -> m.addSecurityDef(this.readSecurityDef((String)name, (Map)def)));
    }

    public void readDefinitions(Map<String, Object> definitions, ApiMetadataBuilder m) {
        if (null == definitions) {
            return;
        }
        definitions.forEach((name, model) -> m.addModel(this.readModel((String)name, (Map)model)));
    }

    public void readResponses(Map<String, Object> responses, ApiMetadataBuilder m) {
        if (null == responses) {
            return;
        }
        responses.forEach((name, resp) -> m.putResponse((String)name, this.readResponse((String)name, (Map)resp)));
    }

    public void readTags(List<Map<String, Object>> tags, ApiMetadataBuilder m) {
        if (null == tags) {
            return;
        }
        for (Map<String, Object> map : tags) {
            JsonObject tag = JsonObject.of(map);
            String name = tag.getString("name");
            String desc = tag.getString("description");
            m.addTag(new MApiTag(name, name, null, desc, null));
        }
    }

    public MApiSecurityDef readSecurityDef(String name, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Object type = map.get("type");
        if (Objects.equals(type, "oauth2")) {
            String authzUrl = Objects.toString(map.get("authorizationUrl"));
            String tokenUrl = Objects.toString(map.get("tokenUrl"));
            String flow = Objects.toString(map.get("flow"));
            MOAuth2ApiSecurityDef def = new MOAuth2ApiSecurityDef(name, name, authzUrl, tokenUrl, flow, map);
            return def;
        }
        return null;
    }

    public MApiModelBuilder readModel(String name, Map<String, Object> map) {
        return this.readModel(name, map, SwaggerExtension.NOP);
    }

    public MApiModelBuilder readModel(String name, Map<String, Object> map, SwaggerExtension ex) {
        MApiModelBuilder mm = new MApiModelBuilder();
        JsonObject model = JsonObject.of(map);
        List requiredProperties = model.getList("required");
        mm.setName(name);
        mm.setTitle(model.getString("title"));
        mm.setSummary(model.getString("summary"));
        mm.setDescription(model.getString("description"));
        mm.setEntity(model.getBoolean("x-entity", Boolean.valueOf(false)));
        Map properties = model.getMap("properties");
        if (null != properties) {
            List<MApiPropertyBuilder> list = this.readProperties(properties, requiredProperties, ex);
            list.forEach(mm::addProperty);
        }
        return mm;
    }

    public List<MApiPropertyBuilder> readProperties(Map<String, Object> properties) {
        return this.readProperties(properties, null);
    }

    public List<MApiPropertyBuilder> readProperties(Map<String, Object> properties, List<String> requiredProperties) {
        return this.readProperties(properties, requiredProperties, SwaggerExtension.NOP);
    }

    public List<MApiPropertyBuilder> readProperties(Map<String, Object> properties, List<String> requiredProperties, SwaggerExtension ex) {
        ArrayList<MApiPropertyBuilder> list = new ArrayList<MApiPropertyBuilder>();
        properties.forEach((propName, propMap) -> {
            MApiPropertyBuilder p = this.readProperty((String)propName, (Map)propMap, ex);
            if (null != requiredProperties && requiredProperties.contains(p.getName())) {
                p.setRequired(true);
            }
            list.add(p);
        });
        return list;
    }

    protected void readParameterBase(String name, JsonObject p, MApiParameterBaseBuilder mp) {
        this.readParameterBase(name, p, mp, SwaggerExtension.NOP);
    }

    protected void readParameterBase(String name, JsonObject p, MApiParameterBaseBuilder mp, SwaggerExtension ex) {
        mp.setName(p.getString("name"));
        mp.setTitle(p.getString("title"));
        mp.setSummary(p.getString("summary"));
        mp.setDescription(p.getString("description"));
        mp.setRequired((Boolean)p.get("required", Boolean.class));
        mp.setType(this.readParameterType(name, p, ex));
        mp.setDefaultValue(p.get("default"));
        MApiValidationBuilder v = new MApiValidationBuilder();
        v.setPattern(p.getString("pattern"));
        v.setMaxLength(p.getInteger("maxLength"));
        v.setMinLength(p.getInteger("minLength"));
        v.setMaximum((Number)p.get("maximum"));
        v.setExclusiveMaximum(p.getBoolean("exclusiveMaximum", Boolean.valueOf(v.isExclusiveMaximum())));
        v.setMinimum((Number)p.get("minimum"));
        v.setExclusiveMinimum(p.getBoolean("exclusiveMinimum", Boolean.valueOf(v.isExclusiveMinimum())));
        List enumValues = p.getList("enum");
        if (null != enumValues) {
            mp.setEnumValues(enumValues.toArray(Arrays2.EMPTY_STRING_ARRAY));
        }
        mp.setValidation(v);
        this.readFormat(p, mp);
    }

    public MApiPropertyBuilder readProperty(String name, Map<String, Object> map) {
        return this.readProperty(name, map, SwaggerExtension.NOP);
    }

    public MApiPropertyBuilder readProperty(String name, Map<String, Object> map, SwaggerExtension ex) {
        MApiPropertyBuilder mp = new MApiPropertyBuilder();
        JsonObject p = JsonObject.of(map);
        this.readParameterBase(name, p, mp, ex);
        mp.setName(name);
        mp.setIdentity(p.getBoolean("x-identity", Boolean.valueOf(false)));
        mp.setUnique(p.getBoolean("x-unique", Boolean.valueOf(false)));
        mp.setSortable((Boolean)p.get("x-sortable", Boolean.class));
        mp.setFilterable((Boolean)p.get("x-filterable", Boolean.class));
        mp.setCreatable((Boolean)p.get("x-creatable", Boolean.class));
        mp.setUpdatable((Boolean)p.get("x-updatable", Boolean.class));
        mp.setExpandable((Boolean)p.get("x-expandable", Boolean.class));
        return mp;
    }

    protected void readFormat(JsonObject json, MApiParameterBaseBuilder p) {
        String type;
        String format = json.getString("format");
        if (!Strings.isEmpty((String)format)) {
            p.setFormat(format);
            if ("password".equals(format)) {
                p.setPassword(true);
            }
        }
        if ("file".equals(type = json.getString("type"))) {
            p.setFile(true);
        }
    }

    protected MApiParameter.Location readParameterIn(String param, String in) {
        if (Strings.isEmpty((String)in)) {
            throw new InvalidSpecException("invalid specification of parameter " + param + ": property named in can not be empty!");
        }
        switch (in) {
            case "body": {
                return MApiParameter.Location.BODY;
            }
            case "path": {
                return MApiParameter.Location.PATH;
            }
            case "query": {
                return MApiParameter.Location.QUERY;
            }
            case "formData": {
                return MApiParameter.Location.FORM;
            }
            case "header": {
                return MApiParameter.Location.HEADER;
            }
        }
        throw new UnsupportedSpecException("Unsupported parameter in '" + in + "' of '" + param + "'");
    }

    protected MType readParameterType(String name, JsonObject p) {
        return this.readParameterType(name, p, SwaggerExtension.NOP);
    }

    protected MType readParameterType(String name, JsonObject p, SwaggerExtension ex) {
        JsonObject schema = p.getObject("schema");
        if (null != schema) {
            return this.readType(schema, ex);
        }
        return this.readType(name, p, ex);
    }

    protected MComplexTypeRef readRefType(String ref) {
        ref = Strings.removeStart((String)ref, (String)"#/definitions/");
        return new MComplexTypeRef(ref);
    }

    protected MCollectionType readCollectionType(JsonObject items, SwaggerExtension ex) {
        return new MCollectionType(this.readType(items, ex));
    }

    protected MType readType(JsonObject property) {
        return this.readType(property, SwaggerExtension.NOP);
    }

    protected MType readType(JsonObject property, SwaggerExtension ex) {
        return this.readType(null, property, ex);
    }

    protected MType readType(String name, JsonObject property, SwaggerExtension ex) {
        MType mtype;
        String ref = property.getString("$ref");
        if (!Strings.isEmpty((String)ref)) {
            return this.readRefType(ref);
        }
        String type = property.getString("type");
        if (Strings.isEmpty((String)type)) {
            if (!this.validate) {
                return null;
            }
            throw new InvalidSpecException("Invalid type in property : " + JSON.stringify((Object)property.raw()));
        }
        MType mType = mtype = null != ex ? ex.readType(type) : null;
        if (null != mtype) {
            return mtype;
        }
        if (type.equals("object")) {
            return this.readObjectType(name, property);
        }
        if (type.equals("array")) {
            return this.readCollectionType(property.getObject("items"), ex);
        }
        String format = property.getString("format");
        return this.readSimpleType(type, format);
    }

    protected MType readObjectType(String name, JsonObject o) {
        JsonObject additionalProperties = o.getObject("additionalProperties");
        if (null == additionalProperties) {
            Object property = o.get("properties");
            if (null != property && property instanceof Map) {
                if (null == name) {
                    name = "Embedded";
                }
                MApiModelBuilder model = this.readModel(name, o.asMap());
                return model.toMComplexType().build();
            }
            return MObjectType.TYPE;
        }
        if (additionalProperties.asMap().isEmpty()) {
            return MObjectType.TYPE;
        }
        MType valueType = this.readType(additionalProperties);
        return new MDictionaryType((MType)MSimpleTypes.STRING, valueType);
    }

    protected MProperty readComplexTypeProperty(String name, Map<String, Object> map) {
        MPropertyBuilder mp = new MPropertyBuilder();
        JsonObject p = JsonObject.of(map);
        mp.setName(name);
        mp.setRequired((Boolean)p.get("required", Boolean.class));
        mp.setType(this.readType(p));
        return mp.build();
    }

    public MSimpleType readSimpleType(String type) {
        return this.readSimpleType(type, "");
    }

    public MSimpleType readSimpleType(String type, String format) {
        switch (type) {
            case "integer": {
                if ("int32".equals(format) || Strings.isEmpty((String)format)) {
                    return MSimpleTypes.INTEGER;
                }
                if ("int64".equals(format)) {
                    return MSimpleTypes.BIGINT;
                }
                throw new InvalidSpecException("Invalid format '" + format + "' of type '" + type + "'");
            }
            case "long": {
                return MSimpleTypes.BIGINT;
            }
            case "double": {
                return MSimpleTypes.DOUBLE;
            }
            case "float": {
                return MSimpleTypes.SINGLE;
            }
            case "byte": {
                return MSimpleTypes.BYTE;
            }
            case "binary": {
                return MSimpleTypes.BINARY;
            }
            case "date": {
                return MSimpleTypes.DATE;
            }
            case "dateTime": {
                return MSimpleTypes.DATETIME;
            }
            case "number": {
                if ("float".equals(format) || Strings.isEmpty((String)format)) {
                    return MSimpleTypes.SINGLE;
                }
                if ("double".equals(format)) {
                    return MSimpleTypes.DOUBLE;
                }
                throw new InvalidSpecException("Invalid format '" + format + "' of type '" + type + "'");
            }
            case "boolean": {
                return MSimpleTypes.BOOLEAN;
            }
            case "string": {
                if ("byte".equals(format)) {
                    return MSimpleTypes.BYTE;
                }
                if ("binary".equals(format)) {
                    return MSimpleTypes.BINARY;
                }
                if ("date-time".equals(format)) {
                    return MSimpleTypes.DATETIME;
                }
                if ("date".equals(format)) {
                    return MSimpleTypes.DATETIME;
                }
                if ("password".equals(format)) {
                    return MSimpleTypes.STRING;
                }
                if (!Strings.isEmpty((String)format)) {
                    // empty if block
                }
                return MSimpleTypes.STRING;
            }
            case "file": {
                return MSimpleTypes.STRING;
            }
        }
        throw new InvalidSpecException("Invalid type '" + type + "'");
    }
}

