/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.spec.swagger;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import leap.core.annotation.Inject;
import leap.lang.New;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.web.Handler;
import leap.web.Request;
import leap.web.Response;
import leap.web.api.Api;
import leap.web.api.Apis;
import leap.web.api.config.ApiConfig;
import leap.web.api.config.ApiConfigProcessor;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.spec.ApiSpecContext;
import leap.web.api.spec.swagger.SwaggerJsonWriter;
import leap.web.assets.AssetStrategy;
import leap.web.route.Route;
import leap.web.route.Routes;

public class SwaggerProcessor
implements ApiConfigProcessor,
ApiMetadataProcessor {
    private static final String SWAGGER_JSON_FILE = "swagger.json";
    @Inject
    protected Apis apis;
    @Inject
    protected AssetStrategy assetStrategy;

    @Override
    public void preProcess(ApiMetadataContext context, ApiMetadataBuilder m) {
        m.getPaths().remove("/swagger.json");
    }

    @Override
    public void completeProcess(final ApiMetadataContext context, ApiMetadata m) {
        ApiConfig config = context.getConfig();
        Routes routes = config.getContainerRoutes();
        Route route = routes.create().enableCors().allowAnonymous().get(this.getJsonSpecPath(config, routes), new Handler(){

            public void handle(Request request, Response response) throws Throwable {
                SwaggerProcessor.this.handleJsonSpecRequest(context.getApi(), request, response);
            }

            public String toString() {
                return SwaggerProcessor.class.getSimpleName() + "(swagger.json)";
            }
        }).build();
        context.getApi().getConfigurator().addDynamicRoute(route, false);
    }

    void handleJsonSpecRequest(Api api, Request req, Response resp) throws Throwable {
        SwaggerJsonWriter w = new SwaggerJsonWriter();
        w.setPropertyNamingStyle(api.getConfig().getPropertyNamingStyle());
        resp.setContentType(w.getContentType());
        Object[] parts = req.getParameterValues("parts");
        if (null != parts && parts.length == 1) {
            parts = Strings.split((String)parts[0], (char)',');
        }
        HashSet partsSet = null == parts ? Collections.emptySet() : New.hashSet((Object[])parts);
        ApiSpecContextImpl context = new ApiSpecContextImpl(req, partsSet);
        String json = this.toSwaggerJson(w, context, api.getMetadata());
        String fingerprint = this.assetStrategy.getFingerprint(json.getBytes());
        resp.setHeader("ETag", "\"" + fingerprint + "\"");
        String ifNoneMatch = req.getHeader("If-None-Match");
        if (!Strings.isEmpty((String)ifNoneMatch) && ifNoneMatch.equals("\"" + fingerprint + "\"")) {
            resp.setStatus(HTTP.SC_NOT_MODIFIED);
        } else {
            resp.getWriter().write(json);
        }
    }

    protected String toSwaggerJson(SwaggerJsonWriter w, ApiSpecContext context, ApiMetadata md) throws IOException {
        StringBuilder out = new StringBuilder();
        w.write(context, md, out);
        return out.toString();
    }

    protected String getJsonSpecPath(ApiConfig c, Routes routes) {
        if (Strings.isEmpty((String)routes.getPathPrefix())) {
            return c.getBasePath() + "/" + SWAGGER_JSON_FILE;
        }
        return "/swagger.json";
    }

    protected static class ApiSpecContextImpl
    implements ApiSpecContext {
        private final Request request;
        private final Set<String> parts;

        public ApiSpecContextImpl(Request request, Set<String> parts) {
            this.request = request;
            this.parts = parts;
        }

        @Override
        public String getHost() {
            return this.request.getServletRequest().getServerName();
        }

        @Override
        public int getPort() {
            return this.request.getServletRequest().getServerPort();
        }

        @Override
        public String getContextPath() {
            return this.request.getContextPath();
        }

        @Override
        public Set<String> getParts() {
            return this.parts;
        }
    }
}

