/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.spec.swagger;

import java.util.ArrayList;
import java.util.Map;
import leap.core.doc.annotation.Doc;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.New;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.json.JsonWriter;
import leap.lang.meta.MCollectionType;
import leap.lang.meta.MComplexType;
import leap.lang.meta.MDictionaryType;
import leap.lang.meta.MSimpleType;
import leap.lang.meta.MSimpleTypeKind;
import leap.lang.meta.MType;
import leap.lang.meta.MTypeRef;
import leap.web.Request;
import leap.web.api.config.ApiConfigException;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiHeader;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.meta.model.MApiModelBuilder;
import leap.web.api.meta.model.MApiOperation;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiParameterBase;
import leap.web.api.meta.model.MApiPath;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.meta.model.MApiProperty;
import leap.web.api.meta.model.MApiPropertyBuilder;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiSecurityDef;
import leap.web.api.meta.model.MApiSecurityReq;
import leap.web.api.meta.model.MApiValidation;
import leap.web.api.meta.model.MOAuth2ApiSecurityDef;
import leap.web.api.spec.ApiSpecContext;
import leap.web.api.spec.JsonSpecWriter;
import leap.web.api.spec.swagger.SwaggerMappings;
import leap.web.api.spec.swagger.SwaggerType;

public class SwaggerJsonWriter
extends JsonSpecWriter {
    protected static final String OAUTH2 = "oauth2";
    protected static final String OAUTH2_ACCESS_CODE = "oauth2_access_code";

    protected boolean isIncluded(ApiSpecContext sc, String part) {
        if (null == sc.getParts() || sc.getParts().isEmpty()) {
            return true;
        }
        return sc.getParts().contains(part);
    }

    @Override
    protected void write(ApiSpecContext sc, ApiMetadata m, JsonWriter w) {
        Args.notNull((Object)m, (String)"metadata");
        Args.notNull((Object)w, (String)"writer");
        WriteContext context = new WriteContext();
        w.startObject();
        w.property("swagger", "2.0");
        w.property("info", () -> {
            w.startObject().property("title", m.getTitle());
            if (this.isIncluded(sc, "info")) {
                w.propertyOptional("summary", m.getSummary()).property("description", Strings.nullToEmpty((String)m.getDescription())).propertyOptional("termsOfService", m.getTermsOfService()).propertyOptional("contact", (Object)m.getConcat());
            }
            w.propertyOptional("version", m.getVersion());
            w.endObject();
        });
        w.propertyOptional("host", this.getHost(sc, m)).propertyOptional("basePath", sc.getContextPath() + Strings.nullToEmpty((String)m.getBasePath())).propertyOptional("schemes", m.getProtocols()).propertyOptional("consumes", m.getConsumes()).propertyOptional("produces", m.getProduces());
        if (this.isIncluded(sc, "paths")) {
            w.property("paths", () -> this.writePaths(context, m, w));
        }
        if (this.isIncluded(sc, "definitions")) {
            w.property("definitions", () -> this.writeDefinitions(context, m, w));
        }
        if (!m.getResponses().isEmpty() && this.isIncluded(sc, "responses")) {
            MApiResponse[] responses = m.getResponses().values().toArray(new MApiResponse[0]);
            w.property("responses", () -> this.writeResponses(context, m, w, responses));
        }
        if (!Arrays2.isEmpty((Object[])m.getSecurityDefs()) && this.isIncluded(sc, "securityDefinitions")) {
            w.property("securityDefinitions", () -> this.writeSecurityDefs(context, m, w));
            this.writeDefaultSecurity(context, m, w);
        }
        if (!Arrays2.isEmpty((Object[])m.getTags()) && this.isIncluded(sc, "tags")) {
            w.property("tags", () -> this.writeTags(context, m, w));
        }
        this.writeExtension(w, m.getExtension());
        w.endObject();
    }

    @Override
    protected void writeModels(ApiSpecContext sc, ApiMetadata m, JsonWriter w) {
        WriteContext context = new WriteContext();
        this.writeDefinitions(context, m, w);
    }

    protected String getHost(ApiSpecContext sc, ApiMetadata m) {
        String host = m.getHost();
        if (!Strings.isEmpty((String)host)) {
            return host;
        }
        if (!Strings.isEmpty((String)sc.getHost())) {
            int port = sc.getPort();
            if (port > 0) {
                return sc.getHost() + ":" + port;
            }
            return sc.getHost();
        }
        return null;
    }

    protected void writeDefaultSecurity(WriteContext context, ApiMetadata m, JsonWriter w) {
        if (null == context.defaultSecurity) {
            return;
        }
        w.property("security", () -> {
            w.startArray();
            w.startObject();
            w.property(context.defaultSecurity, () -> w.array((Object[])m.getPermissions(), p -> w.value(p.getValue())));
            w.endObject();
            w.endArray();
        });
    }

    protected void writePaths(WriteContext context, ApiMetadata m, JsonWriter w) {
        w.startObject();
        for (Map.Entry<String, MApiPath> entry : m.getPaths().entrySet()) {
            w.property(entry.getKey(), () -> this.writePath(context, m, w, (MApiPath)entry.getValue()));
        }
        w.endObject();
    }

    protected void writePath(WriteContext context, ApiMetadata m, JsonWriter w, MApiPath p) {
        w.startObject();
        for (MApiOperation o : p.getOperations()) {
            if (this.checkProfile(o)) continue;
            w.property(o.getMethod().name().toLowerCase(), () -> this.writeOperation(context, m, w, p, o));
        }
        w.endObject();
    }

    private boolean checkProfile(MApiOperation o) {
        String requestProfile;
        Request request;
        if (null == o.getRoute()) {
            return false;
        }
        String[] profiles = this.tryGetProfiles(o);
        return null != profiles && null != (request = Request.tryGetCurrent()) && Strings.isNotBlank((String)(requestProfile = request.getParameter("profile"))) && !Arrays2.containsAny((String[])profiles, (String[])new String[]{requestProfile});
    }

    private String[] tryGetProfiles(MApiOperation o) {
        if (null == o || null == o.getRoute() || null == o.getRoute().getAction() || null == o.getRoute().getAction().getMethod() || null == o.getRoute().getAction().getMethod().getAnnotation(Doc.class)) {
            return null;
        }
        Object[] profiles = ((Doc)o.getRoute().getAction().getMethod().getAnnotation(Doc.class)).profile();
        return Arrays2.isNotEmpty((Object[])profiles) ? profiles : null;
    }

    private void writeExtension(JsonWriter w, MApiExtension extension) {
        if (null != extension) {
            extension.getAttributes().forEach((name, value) -> {
                if (null != value) {
                    w.property("x-" + name, value);
                }
            });
        }
    }

    private void writeModelExtension(WriteContext context, ApiMetadata m, JsonWriter w, MApiExtension extension) {
        if (null != extension) {
            extension.getAttributes().forEach((name, value) -> {
                if (null != value) {
                    if (name.equals("relations")) {
                        Map relations = (Map)Converts.convert((Object)value, Map.class);
                        if (!relations.isEmpty()) {
                            w.property("x-relations", () -> {
                                w.startObject();
                                for (Object relation : relations.values()) {
                                    MApiProperty p = ((MApiPropertyBuilder)((Object)((Object)((Object)Converts.convert(relation, MApiPropertyBuilder.class))))).build();
                                    this.writeModelProperty(context, m, w, p);
                                }
                                w.endObject();
                            });
                        }
                    } else {
                        w.property("x-" + name, value);
                    }
                }
            });
        }
    }

    protected void writeOperation(WriteContext context, ApiMetadata m, JsonWriter w, MApiPath p, MApiOperation o) {
        w.startObject();
        if (null != o.getCorsEnabled()) {
            w.property("x-cors", (Object)o.getCorsEnabled());
        }
        this.writeExtension(w, o.getExtension());
        w.propertyOptional("tags", o.getTags());
        w.propertyOptional("summary", o.getSummary());
        w.property("description", Strings.nullToEmpty((String)o.getDescription()));
        w.propertyOptional("operationId", o.getId());
        if (!o.isAllowAnonymous() && o.getSecurity().length > 0 && m.getSecurityDefs().length > 0) {
            w.property("security", () -> w.array((Object[])o.getSecurity(), sc -> this.writeSecurity(context, m, w, (MApiSecurityReq)sc)));
            if (o.isAllowClientOnly()) {
                w.property("x-security", writer -> {
                    writer.startObject();
                    writer.property("allowClientOnly", true);
                    writer.endObject();
                });
            } else {
                w.property("x-security", writer -> {
                    writer.startObject();
                    writer.property("userRequired", true);
                    writer.endObject();
                });
            }
        }
        if (o.getConsumes().length > 0) {
            w.property("consumes", o.getConsumes());
        }
        if (o.getProduces().length > 0) {
            w.property("produces", o.getProduces());
        }
        if (o.getParameters().length > 0) {
            w.property("parameters", () -> this.writeParameters(context, m, w, o.getParameters()));
        }
        if (o.getResponses().length > 0) {
            w.property("responses", () -> this.writeResponses(context, m, w, o.getResponses()));
        }
        w.endObject();
    }

    protected void writeSecurities(WriteContext context, ApiMetadata m, JsonWriter w, MApiSecurityReq[] sc) {
        if (sc == null) {
            return;
        }
        for (MApiSecurityReq s : sc) {
            this.writeSecurity(context, m, w, s);
        }
    }

    protected void writeSecurity(WriteContext context, ApiMetadata m, JsonWriter w, MApiSecurityReq sc) {
        w.startObject();
        w.property(sc.getName(), sc.getScopes());
        w.endObject();
    }

    protected void writeParameters(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameter[] ps) {
        w.array((Object[])ps, p -> this.writeParameter(context, m, w, (MApiParameter)p));
    }

    protected void writeParameter(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameter p) {
        w.startObject();
        w.property("name", p.getName()).propertyOptional("summary", p.getSummary()).property("description", Strings.nullToEmpty((String)Strings.firstNotEmpty((String[])new String[]{p.getDescription(), p.getSummary(), p.getTitle()}))).property("in", SwaggerMappings.in(p.getLocation()));
        w.propertyOptional("required", p.getRequired());
        this.writeExtension(w, p.getExtension());
        if (MApiParameter.Location.BODY == p.getLocation()) {
            w.property("schema", () -> {
                w.startObject();
                this.writeParameterType(context, m, w, p);
                w.endObject();
            });
        } else {
            this.writeParameterType(context, m, w, p);
        }
        w.endObject();
    }

    protected void writeResponses(WriteContext context, ApiMetadata m, JsonWriter w, MApiResponse[] rs) {
        w.startObject();
        for (MApiResponse r : rs) {
            w.property(r.getName(), () -> this.writeResponse(context, m, w, r));
        }
        w.endObject();
    }

    protected void writeResponse(WriteContext context, ApiMetadata m, JsonWriter w, MApiResponse r) {
        w.startObject();
        w.property("description", Strings.nullToEmpty((String)Strings.firstNotEmpty((String[])new String[]{r.getDescription(), r.getSummary()})));
        MType type = r.getType();
        if (null != type && !type.isVoidType()) {
            w.property("schema", () -> {
                w.startObject();
                this.writeType(context, m, w, type);
                w.endObject();
            });
        }
        if (r.getHeaders().length > 0) {
            w.property("headers", () -> {
                w.startObject();
                for (MApiHeader header : r.getHeaders()) {
                    w.property(header.getName(), () -> {
                        w.startObject();
                        w.property("description", Strings.nullToEmpty((String)header.getDescription()));
                        this.writeType(context, m, w, header.getType());
                        w.endObject();
                    });
                }
                w.endObject();
            });
        }
        w.endObject();
    }

    protected void writeDefinitions(WriteContext context, ApiMetadata m, JsonWriter w) {
        w.startObject();
        for (Map.Entry<String, MApiModel> entry : m.getModels().entrySet()) {
            String name = entry.getKey();
            MApiModel model = entry.getValue();
            w.property(name, () -> this.writeModel(context, m, w, model));
        }
        w.endObject();
    }

    protected void writeSecurityDefs(WriteContext context, ApiMetadata m, JsonWriter w) {
        w.startObject();
        for (MApiSecurityDef def : m.getSecurityDefs()) {
            if (!(def instanceof MOAuth2ApiSecurityDef)) continue;
            this.writeOAuth2SecurityDef(context, m, w, (MOAuth2ApiSecurityDef)def);
        }
        w.endObject();
    }

    protected void writeOAuth2SecurityDef(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d) {
        switch (d.getFlow()) {
            case "implicit": {
                this.writeOAuth2Implicit(context, m, w, d);
                break;
            }
            case "accessCode": {
                this.writeOAuth2AccessCode(context, m, w, d);
                break;
            }
            case "application": {
                this.writeOAuth2Application(context, m, w, d);
                break;
            }
            case "password": {
                this.writeOAuth2Password(context, m, w, d);
                break;
            }
            default: {
                throw new ApiConfigException("not support flow:" + d.getFlow());
            }
        }
    }

    protected void writeOAuth2Implicit(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d) {
        w.property(d.getName(), () -> {
            w.startObject();
            w.property("type", OAUTH2).property("flow", "implicit").property("authorizationUrl", d.getAuthzEndpointUrl());
            this.writeOAuth2Scopes(context, m, w, d, m.getPermissions());
            w.endObject();
        });
    }

    protected void writeOAuth2AccessCode(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d) {
        w.property(d.getName(), () -> {
            w.startObject();
            w.property("type", OAUTH2).property("flow", "accessCode").property("authorizationUrl", d.getAuthzEndpointUrl()).property("tokenUrl", d.getTokenEndpointUrl());
            this.writeOAuth2Scopes(context, m, w, d, m.getPermissions());
            w.endObject();
        });
    }

    protected void writeOAuth2Application(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d) {
        w.property(d.getName(), () -> {
            w.startObject();
            w.property("type", OAUTH2).property("flow", "application").property("tokenUrl", d.getTokenEndpointUrl());
            this.writeOAuth2Scopes(context, m, w, d, m.getPermissions());
            w.endObject();
        });
    }

    protected void writeOAuth2Password(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d) {
        w.property(d.getName(), () -> {
            w.startObject();
            w.property("type", OAUTH2).property("flow", "password").property("tokenUrl", d.getTokenEndpointUrl());
            this.writeOAuth2Scopes(context, m, w, d, m.getPermissions());
            w.endObject();
        });
    }

    protected void writeOAuth2Scopes(WriteContext context, ApiMetadata m, JsonWriter w, MOAuth2ApiSecurityDef d, MApiPermission[] scopes) {
        w.property("scopes", () -> {
            w.startObject();
            if (null != scopes) {
                for (MApiPermission scope : scopes) {
                    w.property(scope.getValue(), Strings.trim((String)scope.getDescription()));
                }
            }
            w.endObject();
        });
    }

    protected void writeTags(WriteContext context, ApiMetadata m, JsonWriter w) {
        w.array((Object[])m.getTags(), tag -> {
            w.startObject();
            w.property("name", tag.getName());
            w.propertyOptional("description", tag.descOrSummaryOrTitle());
            w.endObject();
        });
    }

    protected void writeModel(WriteContext context, ApiMetadata m, JsonWriter w, MApiModel model) {
        w.startObject();
        this.writeModelWithinObject(context, m, w, model);
        w.endObject();
    }

    protected void writeModelWithinObject(WriteContext context, ApiMetadata m, JsonWriter w, MApiModel model) {
        if (!model.hasBaseModel()) {
            w.property("type", "object");
        }
        if (model.isEntity()) {
            w.property("x-entity", true);
        }
        this.writeModelExtension(context, m, w, model.getExtension());
        w.propertyOptional("title", model.getTitle());
        w.propertyOptional("summary", model.getSummary());
        w.propertyOptional("description", model.getDescription());
        if (!model.hasBaseModel()) {
            this.writeModelProperties(context, m, w, model);
        } else {
            w.property("allOf", () -> {
                w.startArray();
                w.startObject().property("$ref", this.ref(model.getBaseName())).endObject();
                w.separator();
                w.startObject().property("type", "object");
                this.writeModelProperties(context, m, w, model);
                w.endObject();
                w.endArray();
            });
        }
    }

    protected void writeModelProperties(WriteContext context, ApiMetadata m, JsonWriter w, MApiModel model) {
        for (MApiProperty p : model.getProperties()) {
            if (!p.isDiscriminator()) continue;
            w.property("discriminator", p.getName());
            break;
        }
        ArrayList requiredProperties = New.arrayList();
        for (MApiProperty p : model.getProperties()) {
            if (!this.isRequired(p)) continue;
            requiredProperties.add(p.getName());
        }
        if (!requiredProperties.isEmpty()) {
            w.property("required", (Object)requiredProperties);
        }
        w.property("properties", () -> {
            w.startObject();
            for (MApiProperty p : model.getProperties()) {
                this.writeModelProperty(context, m, w, p);
            }
            w.endObject();
        });
    }

    protected void writeModelProperty(WriteContext context, ApiMetadata m, JsonWriter w, MApiProperty p) {
        w.property(this.propertyName(p.getName()), () -> {
            w.startObject();
            w.propertyOptional("title", p.getTitle());
            w.property("description", Strings.nullToEmpty((String)Strings.firstNotEmpty((String[])new String[]{p.getDescription(), p.getSummary()})));
            this.writeParameterType(context, m, w, p);
            if (p.isReadonly()) {
                w.property("readOnly", true);
            }
            this.writeExtension(w, p.getExtension());
            if (p.isIdentity()) {
                w.property("x-identity", true);
            }
            if (p.isUnique()) {
                w.property("x-unique", true);
            }
            w.propertyOptional("x-selectable", p.getSelectable());
            w.propertyOptional("x-aggregatable", p.getAggregatable());
            w.propertyOptional("x-groupable", p.getGroupable());
            w.propertyOptional("x-creatable", p.getCreatable());
            w.propertyOptional("x-updatable", p.getUpdatable());
            w.propertyOptional("x-sortable", p.getSortable());
            w.propertyOptional("x-filterable", p.getFilterable());
            if (p.isReference()) {
                w.propertyOptional("x-expandable", p.getExpandable());
            }
            w.endObject();
        });
    }

    protected boolean isRequired(MApiProperty p) {
        return !p.isReadonly() && null != p.getRequired() && p.getRequired() != false;
    }

    protected void writeParameterType(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameterBase p) {
        MType type = p.getType();
        if (type.isSimpleType()) {
            this.writeSimpleParameterType(context, m, w, p, type.asSimpleType());
            return;
        }
        if (type.isObjectType()) {
            this.writeObjectType(context, m, w);
            return;
        }
        if (type.isCollectionType()) {
            this.writeArrayParameterType(context, m, w, p, type.asCollectionType());
            return;
        }
        if (type.isTypeRef()) {
            this.writeRefParameterType(context, m, w, p, type.asTypeRef());
            return;
        }
        if (type.isDictionaryType()) {
            this.writeDictionaryType(context, m, w, type.asDictionaryType());
            return;
        }
        if (type.isComplexType()) {
            MComplexType ct = type.asComplexType();
            MApiModel model = null;
            model = null != ct.getJavaType() ? m.tryGetModel(ct.getJavaType()) : m.tryGetModel(ct.getName());
            if (null != model) {
                this.writeRefType(context, m, w, (MTypeRef)ct.createTypeRef());
            } else {
                model = new MApiModelBuilder(ct).build();
                w.property("type", "object");
                this.writeModelProperties(context, m, w, model);
            }
            return;
        }
        throw new IllegalStateException("Unsupported type kind '" + type.getTypeKind() + "' of parameter '" + p.getName() + "'");
    }

    protected void writeSimpleParameterType(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameterBase p, MSimpleType st) {
        if (p.isFile()) {
            w.property("type", "file");
        } else {
            SwaggerType type = this.writeSimpleType(context, m, w, st);
            if (null != type && null == type.format()) {
                w.propertyOptional("format", p.getFormat());
            }
        }
        w.propertyOptional("default", p.getDefaultValue());
        MApiValidation v = p.getValidation();
        if (null != v) {
            w.propertyOptional("pattern", v.getPattern());
            w.propertyOptional("maxLength", v.getMaxLength());
            w.propertyOptional("minLength", v.getMinLength());
            w.propertyOptional("enum", v.getEnumValues());
            if (null != v.getMaximum()) {
                w.property("maximum", v.getMaximum());
                w.property("exclusiveMaximum", v.isExclusiveMaximum());
            }
            if (null != v.getMinimum()) {
                w.property("minimum", v.getMinimum());
                w.property("exclusiveMinimum", v.isExclusiveMinimum());
            }
        }
        if (null == v || null == v.getEnumValues()) {
            w.propertyOptional("enum", p.getEnumValues());
        }
    }

    protected void writeObjectType(WriteContext context, ApiMetadata m, JsonWriter w) {
        w.property("type", "object");
    }

    protected void writeDictionaryType(WriteContext context, ApiMetadata m, JsonWriter w, MDictionaryType type) {
        w.property("type", "object");
        w.property("additionalProperties", () -> {
            w.startObject();
            this.writeType(context, m, w, type.getValueType());
            w.endObject();
        });
    }

    protected void writeArrayParameterType(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameterBase p, MCollectionType ct) {
        this.writeArrayType(context, m, w, ct);
    }

    protected void writeRefParameterType(WriteContext context, ApiMetadata m, JsonWriter w, MApiParameterBase p, MTypeRef tr) {
        this.writeRefType(context, m, w, tr);
    }

    protected void writeRefType(WriteContext context, ApiMetadata m, JsonWriter w, MTypeRef tr) {
        if (!m.getModels().containsKey(tr.getRefTypeName())) {
            throw new IllegalStateException("The referenced type '" + tr.getRefTypeName() + "' not exists!");
        }
        w.property("$ref", this.ref(tr.getRefTypeName()));
    }

    protected String ref(String name) {
        return "#/definitions/" + name;
    }

    protected void writeArrayType(WriteContext context, ApiMetadata m, JsonWriter w, MCollectionType ct) {
        w.property("type", "array").property("items", () -> {
            w.startObject();
            this.writeType(context, m, w, ct.getElementType());
            w.endObject();
        });
    }

    protected void writeType(WriteContext context, ApiMetadata m, JsonWriter w, MType type) {
        if (type.isVoidType()) {
            return;
        }
        if (type.isSimpleType()) {
            this.writeSimpleType(context, m, w, type.asSimpleType());
            return;
        }
        if (type.isObjectType()) {
            this.writeObjectType(context, m, w);
            return;
        }
        if (type.isCollectionType()) {
            this.writeArrayType(context, m, w, type.asCollectionType());
            return;
        }
        if (type.isTypeRef()) {
            this.writeRefType(context, m, w, type.asTypeRef());
            return;
        }
        if (type.isDictionaryType()) {
            this.writeDictionaryType(context, m, w, type.asDictionaryType());
            return;
        }
        if (type.isComplexType()) {
            MComplexType ct = type.asComplexType();
            if (m.getModels().containsKey(ct.getName())) {
                this.writeRefType(context, m, w, (MTypeRef)((MComplexType)type).createTypeRef());
            } else {
                MApiModel model = new MApiModelBuilder(ct).build();
                this.writeModelWithinObject(context, m, w, model);
            }
            return;
        }
        throw new IllegalStateException("Unsupported type kind '" + type.getTypeKind() + "'");
    }

    public SwaggerType convertSimpleType(MSimpleType st) {
        SwaggerType type = null;
        MSimpleTypeKind k = st.getSimpleTypeKind();
        if (k == MSimpleTypeKind.BIGINT) {
            type = SwaggerType.LONG;
        } else if (k == MSimpleTypeKind.BINARY) {
            type = SwaggerType.BINARY;
        } else if (k == MSimpleTypeKind.BOOLEAN) {
            type = SwaggerType.BOOLEAN;
        } else if (k == MSimpleTypeKind.BYTE) {
            type = SwaggerType.BYTE;
        } else if (k == MSimpleTypeKind.DATETIME) {
            type = SwaggerType.DATETIME;
        } else if (k == MSimpleTypeKind.DATE) {
            type = SwaggerType.DATE;
        } else if (k == MSimpleTypeKind.TIME) {
            type = SwaggerType.TIME;
        } else if (k == MSimpleTypeKind.DECIMAL) {
            type = SwaggerType.DOUBLE;
        } else if (k == MSimpleTypeKind.DOUBLE) {
            type = SwaggerType.DOUBLE;
        } else if (k == MSimpleTypeKind.INTEGER) {
            type = SwaggerType.INTEGER;
        } else if (k == MSimpleTypeKind.SINGLE) {
            type = SwaggerType.FLOAT;
        } else if (k == MSimpleTypeKind.SMALLINT) {
            type = SwaggerType.INTEGER;
        } else if (k == MSimpleTypeKind.STRING) {
            type = SwaggerType.STRING;
        }
        return type;
    }

    protected SwaggerType writeSimpleType(WriteContext context, ApiMetadata m, JsonWriter w, MSimpleType st) {
        SwaggerType type = this.convertSimpleType(st);
        if (null == type) {
            throw new IllegalStateException("Unsupported type '" + st + "' in swagger");
        }
        w.property("type", type.type());
        if (null != type.format()) {
            w.property("format", type.format());
        }
        return type;
    }

    protected static final class WriteContext {
        String defaultSecurity;

        protected WriteContext() {
        }
    }
}

