/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.spec;

import java.io.IOException;
import leap.lang.json.JSON;
import leap.lang.json.JsonWriter;
import leap.lang.json.JsonWriterCreator;
import leap.lang.naming.NamingStyle;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.spec.ApiSpecContext;
import leap.web.api.spec.ApiSpecWriter;

public abstract class JsonSpecWriter
implements ApiSpecWriter {
    protected NamingStyle propertyNamingStyle;

    public NamingStyle getPropertyNamingStyle() {
        return this.propertyNamingStyle;
    }

    public void setPropertyNamingStyle(NamingStyle namingStyle) {
        this.propertyNamingStyle = namingStyle;
    }

    @Override
    public String getContentType() {
        return "application/json;charset=UTF-8";
    }

    @Override
    public void write(ApiSpecContext context, ApiMetadata m, Appendable out) throws IOException {
        this.write(context, m, this.createJsonWriter(out));
    }

    @Override
    public void writeModels(ApiSpecContext context, ApiMetadata m, Appendable out) throws IOException {
        this.writeModels(context, m, this.createJsonWriter(out));
    }

    protected JsonWriter createJsonWriter(Appendable out) {
        JsonWriterCreator writer = JSON.writer((Appendable)out);
        if (null != this.propertyNamingStyle) {
            writer.setNamingStyle(this.propertyNamingStyle);
        }
        return (JsonWriter)writer.create();
    }

    protected String propertyName(String name) {
        return null == this.propertyNamingStyle ? name : this.propertyNamingStyle.of(name);
    }

    protected abstract void write(ApiSpecContext var1, ApiMetadata var2, JsonWriter var3);

    protected abstract void writeModels(ApiSpecContext var1, ApiMetadata var2, JsonWriter var3);
}

