/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.security;

import leap.core.annotation.Inject;
import leap.lang.Strings;
import leap.lang.path.Paths;
import leap.web.Request;
import leap.web.Response;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigProcessor;
import leap.web.api.mvc.ApiErrorHandler;
import leap.web.security.SecurityConfigurator;
import leap.web.security.SecurityContextHolder;
import leap.web.security.SecurityFailureHandler;

public class SecurityConfigProcessor
implements ApiConfigProcessor {
    @Inject
    protected ApiErrorHandler eh;
    @Inject
    protected SecurityConfigurator sc;

    @Override
    public void preProcess(Api api) {
        String prefix = Paths.suffixWithSlash((String)api.getBasePath());
        ApiSecurityFailureHandler failureHandler = new ApiSecurityFailureHandler();
        this.sc.setPathPrefixFailureHandler(prefix, (SecurityFailureHandler)failureHandler);
    }

    protected final class ApiSecurityFailureHandler
    implements SecurityFailureHandler {
        protected ApiSecurityFailureHandler() {
        }

        public boolean handleAuthenticationDenied(Request request, Response response, SecurityContextHolder context) throws Throwable {
            if (Strings.isEmpty((String)context.getDenyMessage())) {
                SecurityConfigProcessor.this.eh.unauthorized(response);
            } else {
                SecurityConfigProcessor.this.eh.unauthorized(response, context.getDenyMessage());
            }
            return true;
        }

        public boolean handleAuthorizationDenied(Request request, Response response, SecurityContextHolder context) throws Throwable {
            if (Strings.isEmpty((String)context.getDenyMessage())) {
                SecurityConfigProcessor.this.eh.forbidden(response);
            } else {
                SecurityConfigProcessor.this.eh.forbidden(response, context.getDenyMessage());
            }
            return true;
        }
    }
}

