/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.sql;

import java.util.Map;
import java.util.function.Function;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.lang.http.HTTP;
import leap.lang.meta.MCollectionType;
import leap.lang.meta.MDictionaryType;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.orm.OrmContext;
import leap.orm.OrmMetadata;
import leap.orm.dao.Dao;
import leap.orm.metadata.MetadataContext;
import leap.orm.query.Query;
import leap.orm.sql.SqlCommand;
import leap.orm.sql.SqlMetadata;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.config.ApiConfigException;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.api.restd.RestdOperationDef;
import leap.web.api.restd.RestdOperationProvider;
import leap.web.api.restd.ScriptOperationProvider;
import leap.web.route.RouteBuilder;

public class SqlOperationProvider
extends ScriptOperationProvider
implements RestdOperationProvider {
    public static final String TYPE = "sql";
    public static final String ARG_SQL_KEY = "sqlKey";

    @Override
    public void createApiOperation(RestdContext context, RestdOperationDef od) {
        String opPath = od.getPath();
        if (Strings.isEmpty((String)opPath)) {
            opPath = "/" + Strings.lowerUnderscore((String)od.getName());
        }
        String path = this.fullPath(context.getApi().getConfigurator(), opPath);
        String key = (String)od.getArgument(ARG_SQL_KEY);
        SqlOperationDef sod = new SqlOperationDef(od.getName(), path, key, od.getScript());
        this.createSqlOperation(context, null, od, sod);
    }

    @Override
    public void createModelOperation(RestdContext context, RestdModel model, RestdOperationDef od) {
        String opPath = od.getPath();
        if (Strings.isEmpty((String)opPath)) {
            opPath = "/" + Strings.lowerUnderscore((String)od.getName());
        }
        String path = this.fullModelPath(context.getApi().getConfigurator(), model, opPath);
        String key = (String)od.getArgument(ARG_SQL_KEY);
        SqlOperationDef sod = new SqlOperationDef(od.getName(), path, key, od.getScript());
        this.createSqlOperation(context, model, od, sod);
    }

    protected void createSqlOperation(RestdContext ctx, RestdModel model, RestdOperationDef od, SqlOperationDef sod) {
        OrmMetadata om = ctx.getDao().getOrmContext().getMetadata();
        SqlCommand sc = null;
        if (!Strings.isEmpty((String)sod.getKey())) {
            sc = om.tryGetSqlCommand(sod.getKey());
            if (null == sc) {
                throw new ApiConfigException("Sql key '" + sod.getKey() + "' not found");
            }
        } else if (!Strings.isEmpty((String)sod.getScript())) {
            OrmContext oc = ctx.getDao().getOrmContext();
            try {
                sc = oc.getSqlFactory().createSqlCommand((MetadataContext)oc, sod.getScript()).prepare((MetadataContext)oc);
            }
            catch (Exception e) {
                throw new ApiConfigException("Error parsing sql of operation '" + sod.getName() + "', " + e.getMessage(), e);
            }
        }
        this.createSqlOperation(ctx, model, od, sod, sc);
    }

    protected void createSqlOperation(RestdContext ctx, RestdModel model, RestdOperationDef od, SqlOperationDef op, SqlCommand sc) {
        if (!sc.hasMetadata()) {
            throw new ApiConfigException("Sql '" + op.getKey() + "' has no metadata!");
        }
        SqlMetadata sm = sc.getMetadata();
        if (sm.isUnknown()) {
            throw new ApiConfigException("Sql '" + op.getKey() + "' is unknown!");
        }
        String verb = sm.isSelect() ? "GET" : (sm.isInsert() ? "POST" : (sm.isUpdate() ? "PATCH" : "DELETE"));
        MApiOperationBuilder mo = od.getMetaOperation();
        if (null == mo) {
            mo = new MApiOperationBuilder();
            mo.setName(op.getName());
            mo.setMethod(HTTP.Method.valueOf((String)verb));
        } else if (null != mo.getMethod()) {
            verb = mo.getMethod().name();
        }
        String path = op.getPath();
        Dao dao = ctx.getDao();
        FuncActionBuilder action = new FuncActionBuilder();
        RouteBuilder route = this.rm.createRoute(verb, path);
        action.setName(op.getName());
        if (!sm.getParameters().isEmpty()) {
            for (SqlMetadata.Param param : sm.getParameters()) {
                if (mo.getParameter(param.getName()) != null) continue;
                MApiParameterBuilder p = new MApiParameterBuilder();
                p.setName(param.getName());
                p.setRequired(true);
                p.setType((MType)MSimpleTypes.STRING);
                this.setDefaultLocation(route, p);
                mo.addParameter(p);
            }
        }
        this.createArguments(route, action, mo);
        action.setReturnType(ApiResponse.class);
        action.setExtension((Object)mo);
        if (mo.getResponses().isEmpty()) {
            if (sm.isSelect()) {
                this.addQueryResponse(ctx, sc, action, mo);
            } else {
                this.addUpdateResponse(ctx, sc, action, mo);
            }
        }
        MType returnType = mo.getResponses().get(0).getType();
        action.setFunction((Function)new SqlFunction(od.getScriptPath(), op.key, dao, sc, returnType));
        if (null != model) {
            this.preConfigure(ctx, model, action);
        }
        this.preConfigure(ctx, route, action, mo);
        route.setAction((Action)action.build());
        this.postConfigure(ctx, model, route, mo);
        if (!od.isExplicitPrior() && this.isOperationExists(ctx, route) && !od.isExplicitNotPrior()) {
            throw new ApiConfigException("Sql operation '" + op.getName() + "' with path '" + path + "' already exists!");
        }
        ctx.getApi().getConfigurator().addDynamicRoute(this.rm.loadRoute(ctx.getRoutes(), route));
    }

    protected void addQueryResponse(RestdContext ctx, SqlCommand sc, FuncActionBuilder action, MApiOperationBuilder mo) {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(200);
        r.setType((MType)new MCollectionType((MType)MDictionaryType.INSTANCE));
        r.setDescription("Success");
        mo.addResponse(r);
    }

    protected void addUpdateResponse(RestdContext ctx, SqlCommand sc, FuncActionBuilder action, MApiOperationBuilder mo) {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(200);
        r.setType((MType)MSimpleTypes.INTEGER);
        r.setDescription("Success");
        mo.addResponse(r);
    }

    protected static final class SqlOperationDef {
        private final String name;
        private final String path;
        private final String key;
        private final String script;

        public SqlOperationDef(String name, String path, String key, String script) {
            this.name = name;
            this.path = path;
            this.key = key;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getKey() {
            return this.key;
        }

        public String getScript() {
            return this.script;
        }
    }

    private class SqlFunction
    implements Function<ActionParams, Object> {
        private final String path;
        private final String key;
        private final Dao dao;
        private final SqlCommand command;
        private final MType returnType;

        public SqlFunction(String path, String key, Dao dao, SqlCommand command, MType returnType) {
            this.path = path;
            this.key = key;
            this.dao = dao;
            this.command = command;
            this.returnType = returnType;
        }

        @Override
        public Object apply(ActionParams params) {
            Object result;
            Map map = params.toMap();
            if (this.command.getMetadata().isSelect()) {
                Query query = this.dao.createQuery(this.command).params(map);
                result = null != this.returnType ? (this.returnType.isSimpleType() ? Converts.convert((Object)query.scalarValueOrNull(), (Class)this.returnType.asSimpleType().getJavaType()) : (this.returnType.isCollectionType() && this.returnType.asCollectionType().getElementType().isSimpleType() ? query.scalars().list(this.returnType.asCollectionType().getElementType().asSimpleType().getJavaType()) : query.list())) : query.list();
            } else {
                result = this.dao.executeUpdate(this.command, map);
                if (null != this.returnType) {
                    result = Converts.convert((Object)result, (Class)this.returnType.asSimpleType().getJavaType());
                }
            }
            return ApiResponse.of(result);
        }

        public String toString() {
            if (!Strings.isEmpty((String)this.path)) {
                return this.path;
            }
            if (!Strings.isEmpty((String)this.key)) {
                return "@" + this.key;
            }
            return super.toString();
        }
    }
}

