/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.Map;
import java.util.function.Function;
import leap.lang.Strings;
import leap.orm.dao.Dao;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelUpdateExecutor;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.orm.UpdateOneResult;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.exception.NotFoundException;
import leap.web.route.RouteBuilder;

public class UpdateOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "update";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowUpdateModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model) + this.getIdPath(model);
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("PATCH", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addIdArguments(context, action, model);
        this.addModelArgumentForUpdate(context, action, model);
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addNoContentResponse(action, model);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new UpdateFunction(context.getApi(), context.getDao(), model, start);
    }

    protected class UpdateFunction
    extends CrudOperationBase.CrudFunction {
        public UpdateFunction(Api api, Dao dao, RestdModel model, int start) {
            super(api, dao, model, start);
        }

        @Override
        public Object apply(ActionParams params) {
            MApiModel am = this.am();
            Object id = this.id(params);
            Map record = this.recordWithId(params);
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelUpdateExecutor executor = this.newUpdateExecutor(context);
            UpdateOneResult result = executor.partialUpdateOne(id, record);
            if (null != result.entity) {
                return ApiResponse.of(result.entity);
            }
            if (result.affectedRows > 0) {
                return ApiResponse.NO_CONTENT;
            }
            throw new NotFoundException(am.getName() + "' " + id.toString() + "' not found");
        }

        protected ModelUpdateExecutor newUpdateExecutor(ModelExecutorContext context) {
            return UpdateOperation.this.mef.newUpdateExecutor(context);
        }

        public String toString() {
            return "Function:Update " + this.model.getName() + "";
        }
    }
}

