/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.ArrayList;
import java.util.function.Function;
import leap.lang.Strings;
import leap.orm.dao.Dao;
import leap.web.Request;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.orm.ExpandError;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.route.RouteBuilder;

public class QueryOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "query";
    public static final String QUERY_EXPAND_ERROR = "webapi.errors.query_expand_error";
    public static final String ALLOW_EXPAND_ERROR = "x-allow-expand-err";
    public static final String ERROR_EXPANDS = "x-err-expands";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowQueryModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model);
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("GET", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addArgument(context, action, QueryOptions.class, "options");
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addModelQueryResponse(action, model);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new QueryFunction(context.getApi(), context.getDao(), model, start);
    }

    protected class QueryFunction
    extends CrudOperationBase.CrudFunction
    implements Function<ActionParams, Object> {
        public QueryFunction(Api api, Dao dao, RestdModel model, int start) {
            super(api, dao, model, start);
        }

        @Override
        public Object apply(ActionParams params) {
            boolean hasExpandErrors;
            QueryOptions options;
            MApiModel am = this.am();
            Request request = params.getContext().getRequest();
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelQueryExecutor executor = this.newQueryExecutor(context);
            QueryListResult result = executor.queryList(options = (QueryOptions)this.getWithoutId(params, 0));
            boolean bl = hasExpandErrors = null != result.getExpandErrors() && !result.getExpandErrors().isEmpty();
            if (hasExpandErrors && !this.allowExpandErrors(request)) {
                return ApiResponse.err(request.getMessageSource().getMessage(QueryOperation.QUERY_EXPAND_ERROR, new Object[0]));
            }
            ApiResponse response = null != result.getEntity() ? ApiResponse.of(result.getEntity()) : (result.getCount() == -1L ? ApiResponse.of(result.getList()) : ApiResponse.of(result.getList()).setHeader("X-Total-Count", String.valueOf(result.getCount())));
            if (hasExpandErrors) {
                ArrayList<String> expands = new ArrayList<String>();
                for (ExpandError ee : result.getExpandErrors()) {
                    expands.add(ee.getExpand());
                }
                response.withHeader(QueryOperation.ERROR_EXPANDS, Strings.join(expands, (char)','));
            }
            return response;
        }

        protected ModelQueryExecutor newQueryExecutor(ModelExecutorContext context) {
            return QueryOperation.this.mef.newQueryExecutor(context);
        }

        protected boolean allowExpandErrors(Request request) {
            return "1".equals(request.getHeader(QueryOperation.ALLOW_EXPAND_ERROR));
        }

        public String toString() {
            return "Function:Query " + this.model.getName() + "";
        }
    }
}

